/*
 *    Console V 1.2 
 *
 * Interface console - mode text
 * Etant une interface elle implemente UInterface
 */

import java.io.*;

class Console implements UInterface {

   boolean verbose=false;
   boolean start=false;
   private int i=0;
   private String CMDz[] = new String[10];
   private String CMDtitle[] = new String[10];
   private String gnuplotCMD="/usr/local/bin/gnuplot";
   private String plotheader="set xtics nomirror\nset ytics nomirror\nset xtics 50";

// Constructeur(s)
public Console() {
    System.out.println("\n\t\t\t\tInterface CONSOLE - Bienvenue");
    System.out.println("\t\t\t\t\tVersion 1.2");
    askDebug();   
}

/**---------- Methodes propres a la class Console -------------*/
//--- Saisie d'un entier en mode texte.
private static int read_int() {
    
    BufferedReader BUF = new BufferedReader (new InputStreamReader(System.in));
    int x=0;
    String s="";

    System.out.print("Rentrez un nombre entier positif -> ");
    try {
	  s = BUF.readLine();
	}
    catch (Exception ohlala) {
	System.out.println("\tERROR:Console:read_int():   BufferedReader system error.");
	return 1;
    }

    try {
	  x= (new Integer(s)).intValue();
    } catch (Exception ooo) {
	System.out.println("\tMisuse: Bad format in read_int()");
	System.out.println("\tusage: rentrez un entier positif");
	return read_int();
    }

  System.out.println(); // Saut de ligne apres saisie --> Clartee
  if(x<0) {
      System.out.println("===info : Vous avez rentrez une valeur negative -> valeur absolue prise en compte :"+(x=(0-x)));
  }
  return x;
}


/**---------- Methode de l'interface UInterface ----------------*/

public void askDebug() {
    System.out.print("\n\n\t1- Sans messages de debuggage\n\t2- Avec messages de debuggage\n\t");
    if(read_int()==1) verbose=false;
    else verbose=true;
}


public boolean askQuit() {
    if(!start) { start=true; return false;  }

     System.out.println("Voulez-vous tristement arreter le programme ? [ 1=non | autre entier =oui ]");
     if (read_int()==1) {
	 askDebug();
	 return false;
     }
     else return true;
}



public int askInt() {
    return read_int();
}


public int askPricingType() {
    System.out.println("\nSelectionnez le type de Pricing que vous voulez simuler.");
    System.out.println("\n\t0 -> Flat Pricing\n\t1 -> Priority Pricing");
    System.out.println("\t2 -> Time Of Day Pricing (TOD Pricing)\n");
    
    // Je remet a zero l'enregistreur de fichier commande pour les graphes. CMDz.
    i=0;
    return read_int();
}



public void showInfo(String s) {
    System.out.println(" ===info: "+s);
}



public void showAlert(String s) {
    System.out.println(" ***Alert: "+s);
}


/** Affiche un message de debuggage si l'utilisateur est en mode verbose=oui */
public void showDebug(String s) {
    if(verbose)
    System.out.println(" +++DEBUG --> "+s);
}

//------------------ les courbes sur graphes --------------------//

public void resetGraph() { i=0; }

public void showGraph(String file, String title) {
    showGnuplot(file, title);
}


/** Enregistrement du nom de fichier commande Gnuplot */
public void saveGraph(String file, String title) {
    CMDz[i]= file;
    CMDtitle[i]= title;
    i++;
}


/** Dessin des courbes grace a Gnuplot.
    Chaque courbe est enregistree en memoire pour etre reaffichee par showAllGraphs.
     */
public void showGnuplot(String file, String title) {

    Log command = new Log(file+"CMD");
    command.ecrire("plot '"+file+"' using 1:2 smooth unique title \""+title+"\"");
    command.fermer();
    
    // J'enregistre le nom de fichier commande pour plus tard.
    CMDz[i]= file;
    CMDtitle[i]= title;
    i++;
    
    try {
    Process proc = Runtime.getRuntime().exec(gnuplotCMD +" -persist "+file+"CMD");
    }
    catch (Exception ohho) { 
	showAlert("Probleme d'execution de la commande de visualisation :\n"
	   +"\t\tLa commande /usr/bin/gnuplot ce trouve peut etre ailleur son ton architecture;"
	   +"\n\t\texemple: \t/usr/local/bin/gnuplot\nIl faut la modifier a la main dans Console.java");
    }
}


/** Dessin des courbes grace a Gnuplot.
    Chaque courbe est enregistree en memoire pour etre reaffichee par showAllGraphs.
     */
public void showGnuplot(String file, String title, String xlabel, String ylabel) {

    Log command = new Log(file+"CMD");
    command.ecrire("set xlabel \""+xlabel+"\""
                   +"\nset ylabel \""+ylabel+"\"");
    command.ecrire("plot '"+file+"' using 1:2 smooth unique title \""+title+"\"");
    command.fermer();
    
    // J'enregistre le nom de fichier commande pour plus tard.
    CMDz[i]= file;
    CMDtitle[i]= title;
    i++;
    
    try {
    Process proc = Runtime.getRuntime().exec(gnuplotCMD +" -persist "+file+"CMD");
    }
    catch (Exception ohho) { 
	showAlert("Probleme d'execution de la commande de visualisation :\n"
	   +"\t\tLa commande /usr/bin/gnuplot ce trouve peut etre ailleur sur votre architecture;"
	   +"\n\t\texemple: \t/usr/local/bin/gnuplot\nIl faut la modifier a la main dans Console.java");
    }
}


/**  Affiche toutes les courbes gardees ayant ete gardee en memoire.
     La memoire est remise a zero. */
public void showAllGraphs() {
    Log command = new Log(".consolePloting");
    String s="";
    boolean prob=false;
    
    for(int j=0; j<i; j++) {
	if (s=="")
	    s+="plot '"+CMDz[j]+"' using 1:2 smooth unique title \""+CMDtitle[j]+"\" ";
	else
	    s+=", '"+CMDz[j]+"' using 1:2 smooth unique title \""+CMDtitle[j]+"\" ";
    }

    command.ecrire(plotheader);
    command.ecrire(s);
    command.fermer();
     try {
	   Process proc = Runtime.getRuntime().exec(gnuplotCMD+" -persist .consolePloting");
     } catch( Exception ok) {
	prob=true;
	showAlert("Probleme d'execution de la commande de visualisation :\n"
	   +"\t\tLa commande /usr/bin/gnuplot ce trouve peut etre ailleur sur votre architecture;"
	   +"\n\t\texemple: \t/usr/local/bin/gnuplot\nIl faut la modifier a la main dans Console.java");
     }
//     if(!prob)
	    // Remet a zero le tableau CMDz[], permet de ne pas reafficher les graphes deja afficher ici. 
	    i=0;
}



//** End Of Class **//
}
