 /**
 * la classe FlatPricing qui implemente les methodes necessaires 
 * a la simulation 
 * version 1.2a
*/

class FlatPricing extends XPricing{

    private static final int RICH = 600, POOR = 60;//budget d' un RICHe, d' un pauvre
    private static final double PROBA_A = 0.8, PROBA_B = 0.2;//proba qu' user soit de la classe A  
    private static final double PROBA_POOR = 0.8, PROBA_RICH = 0.2;//proba qu' un user soit pauvre
    private static final int A_USE = 1, B_USE = 5;// % de bp utilisee pr la classe A

    private static final int TIME_A = 36, TIME_B = 240;// duree moy de com  pr la classe A
    private int use, nb_it, gain_total=0, total_use=0, wastingtime=0, price, temps_moyen=0;
    private int appels_restants, connected=0;
    private int moy = -1;//moyenne d' arrivee par it
    //MOY c'est la moyenne de la loi de poisson 
    private ListeC connected_users = new ListeC(); 
    private ListeC waiting_users = new ListeC();
    double insatisftot=0.;
    boolean par_it, warm_up;
    int insatisfaits=0;
    int rejetes=0;
    int prix_depart, prix_max;
    int riches=0,pauvres=0,nb_appels=0;
    int a=0,b=0;
    double lassitude=0.;

public FlatPricing (UInterface UI) {
	super(UI);
	UI.showInfo("\t\t FLAT PRICING\n");
	UI.showInfo("\tVoulez - vous executer une simulation pour un prix fixe"
		    +"\n\t\t ou pour une fourchette de prix"
		    +"\n\t\t 0 pour un prix fixe "
		    +"\n\t\t 1 pour faire varier les prix");
  
	if(UI.askInt() == 0)
	    par_it = true;
	else
	    par_it = false;
 
	config();

    }

  
/*---------------------------------------------------------------*/

public void launchSimulation() 
    {
	int gain_total=0, total_use=0;
	
	if(par_it)
	    {
		parIt();		
	    }//fin du if
	else
	    {
		prixVariable();
	    }
	//print_price((int)(((double)total_use)/((double)(nb_it*BANDE))*100),"util_moy");
	UI.showDebug("temps d' attente moyen  :"+wastingtime);
	//UI.showInfo("utilisation moyenne de la bande  :"+(int)(((double)total_use)/((double)(nb_it*BANDE))*100));

	UI.showDebug(nb_it+"  riches:"+riches+"   pauvres:"+pauvres);
	UI.showDebug("A  :"+a+"   B:"+b);	
    }


/*---------------------------------------
  |					|
  |					|
  ----------------------------------------*/
  
    /** effectue une simulation pour un prix fixe*/
    private void parIt()
    {
    	
	Log gain_par_it = new Log("FPF_gain_par_it_"+price);//un objet pour ecrire dans gain_par_it
	Log utilisation_par_it = new Log("FPF_utilisation_bande_"+price);//idem
	Log insatisfmoyLog   = new Log ("FPF_sattot_"+price);	
	Log lassitudeLog = new Log ("FPF_lasse_"+price);
	
	double lass=0.;
	
	
  	warmUp(200);//represente les x it d' initialisation
	utilisation_par_it.ecrire(Log.formater(0,use));
	gain_par_it.ecrire(Log.formater(0,0));
	//gain_total = use*price;
	warm_up = false;
	insatisfaits=0;
	insatisftot=0.;
	int sen_vont=0,i=0;
	while(appels_restants!=0 || !connected_users.isEmpty() || !waiting_users.isEmpty())
	    {
	
		if(appels_restants!=0)
		    newUsers();//place les nouveaux dans la liste d' attente
		
		
		connectWaiters();//si possible fais passer les waiters dans les connected
		
		
		lassitude +=((double)waiting_users.getLassitude()*100./(double)waiting_users.numberOfClients());
		lass += lassitude;		
		
		//lassitude+=100*waiting_users.deleteWaitOff();
		//on peut le mettre comme on peut s' en passer
			
		connected_users.decreaseCallDuration();//retire un IT a chaque client connecte
		
		waiting_users.increaseWaiting();//ajoute un au temps d' attente de chaque waiter
		
		
		
		gain_total += use*price;//calcule le gain pour cet IT et ecris dans le fichier gain_par_it

			
		
		use -= connected_users.deleteTimeOff();//vire les connectes ayant termine leur communication
		sen_vont += waiting_users.deleteWaitOff();//vire les gens qui attendent plus longtemps que leur tps de com
		//QUESTION ceux qui s' en vont ont une insatisfaction de 100 les rajoute t on?
	
		total_use += use;		 
		
		//if(par_it)
		
		if(insatisfaits == 0)
			insatisfmoyLog.ecrire(Log.formater(nb_it, insatisftot));
		else
			insatisfmoyLog.ecrire(Log.formater(nb_it, (double) insatisftot / (double) insatisfaits));
		
		utilisation_par_it.ecrire(Log.formater(nb_it,use)); 
		gain_par_it.ecrire(Log.formater(nb_it,use*price));
		lassitudeLog.ecrire(Log.formater(nb_it, lassitude));
		
		nb_it++; 
		
		
		insatisfaits=0;
		insatisftot=0.;
		lassitude=0.;
		if(i<50)
			UI.showDebug("lass     "+lass);
	    i++;
	    }
	
	//System.out.println("lass     "+lass);
	gain_par_it.fermer();
	utilisation_par_it.fermer();
	insatisfmoyLog.fermer();
	lassitudeLog.fermer();
		
	UI.showInfo("\tSTATISTIQUES ....\n"
			+"Gain fournisseur   				:"+gain_total+"\n"
			+"Utilisation moyenne de la bande par IT          :"+(int)(((double)total_use)/((double)(nb_it*BANDE))*100)+"\n"
			+"Temps maximum attendu par un client		:"+wastingtime+"\n"
			+"Temps moyen d' attente des clients		:"+(int)((double)temps_moyen/(double)connected)+"\n"
			+"Insatisfaction moyenne d' un client		:"
			+(((double)insatisftot/(double)connected))+"\n"
			+"Nombre de clients rejetes			:"+rejetes+"\n"
			+"Nombre de clients partis avant leur comm	:"+sen_vont+"\n"
			+"Lassitude moyenne sur la simulation par client:"+lass+"\n"
			+"Nb total de clients"+(rejetes+connected)+" || "+nb_appels);
	
	
	
	
	UI.showGnuplot(gain_par_it.getFileName(),"Gain du fournisseur par IT");
	UI.showGnuplot(utilisation_par_it.getFileName(),"Utilisation de la bande passante par IT");
	UI.showGnuplot(insatisfmoyLog.getFileName(),"Insatisfaction des nouveaux arrivants par IT");
	UI.showGnuplot(lassitudeLog.getFileName(),"Lassitude moyenne des utilisateurs par IT");

	UI.showAllGraphs();//met tous les graphes sur une seule fenetre
    
    }//fin de la methode pour un prix fixe
    
    
 /*----------------------------------------------------------------------*/     
private void prixVariable()
{
boolean detailler = true;
UI.showInfo("Voulez detailler certains fichiers? \n\tO pour oui\n\t1 pour non");
	if(UI.askInt() == 0)
		detailler = true;
	else
		detailler = false;

     Log gaintotalLog   = new Log ("FPV-gaintotal-"+prix_depart+"-"+prix_max);
     Log utilmoy_priLog = new Log ("FPV-utilmoy-pri-"+prix_depart+"-"+prix_max);
     Log temps_maxLog   = new Log ("FPV-T-max-"+prix_depart+"-"+prix_max);
     Log temps_moyenLog = new Log ("FPV-T-moyen-"+prix_depart+"-"+prix_max);
     Log insatisftotLog   = new Log ("FPV_insatmoy_"+prix_depart+"-"+prix_max);
     Log lassitudeLog = new Log ("FPV-lasse-"+prix_depart+"-"+prix_max);	
    
    gaintotalLog.ecrire(Log.formater(0,0));
    
    price = prix_depart;	
	
   /* 
   if(prix_depart>prix_max)
	{
		int tmp=prix_depart;
		prix_depart=prix_max;
		prix_max = tmp;
	}
	*/
	while(price<=prix_max)
	    {
	    	warm_up=true;
	    	warmUp(200);
		insatisfaits=0;
		insatisftot=0;
	
		nb_it=0;
		warm_up = false;
		appels_restants =nb_appels;
		UI.showDebug("Gaintotal avant:"+gain_total);
		double lass=0.;
		int sen_vont=0;
		lass=0.;
		lassitude=0;
		
		while(appels_restants!=0 || !connected_users.isEmpty() || !waiting_users.isEmpty())
		    {
		    
			//UI.showInfo("IT numero  "+it);
			if(appels_restants!=0)
			    newUsers();//place les nouveaux dans la liste d' attente
			    
			
			connectWaiters();//si possible fais passer les waiters dans les connected
			
			
			connected_users.decreaseCallDuration();//retire un IT a chaque client connecte
			
			waiting_users.increaseWaiting();//ajoute un au temps d' attente de chaque waiter
			int divise = (waiting_users.numberOfClients() == 0 ? 1 : waiting_users.numberOfClients());
			lassitude =(waiting_users.getLassitude()*100.)/(double)divise;
			//System.out.println((double)waiting_users.getLassitude()+" || "+(double)waiting_users.numberOfClients());
			lass += lassitude;		
			
			gain_total += use*price;//calcule le gain pour cet IT et ecris dans le fichier gain_par_it
			
			use -= connected_users.deleteTimeOff();//vire les connectes ayant termine leur communication
		
			sen_vont += waiting_users.deleteWaitOff();//vire les gens ayant attendu plus que ce qu' ils devaient attendre
			
			total_use += use;		 
			
			nb_it++; 
		     }//fin de simulation pour un prix
	
	    
	  /*
	  	gain_total ==> revenu fournisseur pour la simulation
	 	(int)(((double)total_use)/((double)(nb_it*BANDE))*100) ==> utilisation moyenne de la bande pour une simu
		 wastingtime ==> temps max attendu par un utilisateur
		temps_moyen/connected ==> moyenne des temps d' attente des utilisateurs
	 	satisfmin ==> insatisfaction minimum ressentie par un utilisateur durant la simu
	 	satisfmax ==> insatisfaction maximum ressentie par un utilisateur durant la simu
	 	insatisftot/connected ==> insatisfaction moyenne des utilisateurs
	 */
	    
	if(insatisfaits == 0)
		insatisftotLog.ecrire(Log.formater(price, insatisftot));
	
	
	gaintotalLog.ecrire(Log.formater (price,gain_total));
	utilmoy_priLog.ecrire(Log.formater (price, (int)(((double)total_use)/((double)(nb_it*BANDE))*100)));
	lassitudeLog.ecrire(Log.formater (price, (lass/(double)(nb_it))));
	//ici j' ai divise par 100 a un moment
	if(price<10 && detailler)
	{
		temps_moyenLog.ecrire(Log.formater (price, (int)((double)temps_moyen/(double)connected)));
		temps_maxLog.ecrire(Log.formater (price, wastingtime));
		insatisftotLog.ecrire(Log.formater (price, (int)((double)insatisftot/(double)(connected+rejetes))));
	}
	else
	{
		temps_moyenLog.ecrire(Log.formater (price, (int)((double)temps_moyen/(double)connected)));
		temps_maxLog.ecrire(Log.formater (price, wastingtime));
		insatisftotLog.ecrire(Log.formater (price, (insatisftot/(double)(insatisfaits))));
		//System.out.println("nb tot de clients  insatisfaits:"+insatisfaits);
		//System.out.println("insatisfaction      :"+insatisftot);
	}
	
	init();
	insatisfaits=0;
	insatisftot=0;
	
	price++;
}
	gaintotalLog.fermer();
	utilmoy_priLog.fermer();
	temps_maxLog.fermer();
	temps_moyenLog.fermer();
	insatisftotLog.fermer();
	lassitudeLog.fermer();
	
	//UI.showGnuplot(.getFileName(),"");
	
	UI.showGnuplot(utilmoy_priLog.getFileName(),"Utilisation moyenne de la bande pour une simu par prix");
	UI.showGnuplot(temps_maxLog.getFileName(),"Temps maximum d' attente d' un utilisateur pour un prix");
	UI.showGnuplot(temps_moyenLog.getFileName(),"Temps moyen d' attente des utilisateurs");
	UI.showGnuplot(insatisftotLog.getFileName(),"Insatisfaction moyenne ressentie par les utilisateurs par prix");
	UI.showGnuplot(lassitudeLog.getFileName(),"Lassitude moyenne des utilisateurs par Prix");
	UI.showAllGraphs();//met tous les graphes sur une seule fenetre
	UI.showGnuplot(gaintotalLog.getFileName(),"Gain du fournisseur par prix");	
		
    }//fin de prixVariable
    
/*---------------------------------------------------------------*/
/** reinitialise les variables de classe */ 
private void init()
{
    gain_total=0;use=0;total_use=0;nb_it=0;connected = 0;
    a=0;b=0;rejetes=0;connected=0;rejetes=0;
    riches=0;pauvres=0;wastingtime=0;temps_moyen=0;insatisftot=0.;
    insatisfaits=0;
    //UI.showDebugInfo(satisfmin+"||"+satisfmax+"||"+insatisftot+"||"+gain_total+"||"+use+"||"+total_use+"||"+nb_it+"||"+connected);
}
    
    /** 
     *	fonction qui initialise les clients et cherche a les 
     *  caser sur la bande ou dans la liste waiting _users
     */ 
//warm_up est a true si on est dans le warm_up
private void newUsers ()
    {
	int news = super.newUsers (moy, appels_restants);//majore le nb d'arrivants par le nb d' appels restants
	for(int i = 0;i < news; i++) 
	{

	    //on definit le profil du nouvel utilisateur
	    def_user();//cree un client si il peut se payer au mooins un it
	    //et le place dans la liste d'attente
	    
	  if(!warm_up) 
	  	appels_restants--;//un nouveau a appelle on comptabilise son appel hors warm-up
	  //else 
	  //	UI.showInfo("connectes pour un tour :"+news);
	}
 
    }

    
/*---------------------------------------------------------------*/
/**definit le profil du client qui vient de se connecter*/
private void def_user ()
    { 
	Client client = new Client ();//cree un client vide a initialiser
	//on tire son budget
       	client.setBudget (budget ());//initialise le budget
	client.setBWU (band ());//initialise le taux d' utilisation dc la classe 
	callDuration (client);//initialise la duree d' appel et calcule la insatisfaction
	
	if(client.getCallDuration()==0 && !warm_up)
	rejetes++;
	// on ne met pas les utilisateurs ne pouvant rien se payer dans la liste d' attente car 
	//on ne les vire pas tout de suite et il rentre dans les stats comme ayant attendu
	//pour se faire recaler ...
	
	if(client.getCallDuration() > 0 && !warm_up)
	{
	
		waiting_users.insertLast (client);
		connected++;
			
	}
}

/**
	Definit le budget d' un utilisateur
	@return Le budget de l' utilisateur nouvellement cree
*/

private double budget()
    {
	//on tire le budget
	
	if(Math.random()<Math.max(PROBA_POOR,PROBA_RICH))
	    {
	    if(!warm_up)
	    {
	    	int a = (PROBA_RICH < PROBA_POOR ? pauvres++ : riches++);
	    }
	return (PROBA_RICH < PROBA_POOR ? POOR : RICH);
	//si on a tire un chiffre inferieur a la proba max
	//si la proba max est celle des pauvre on retourne le budget des pauvres
	//sinon on retourne le budget des riche
	    } 
	else
	    {
	    if(!warm_up)
	   	{
			int b= (PROBA_RICH < PROBA_POOR ? riches++ : pauvres++ );
		}
		//on a tire un chiffre superieur a la proba max 
		//donc on est dans le cas le moins frequent
		//si le cas special est celui des riches on retourne le budget des riches
		//sinon on retourne le budget des pauvres
		return (PROBA_RICH < PROBA_POOR ? RICH : POOR);
	    }
    }
        
private int band () 
    {
	if(Math.random()<Math.max(PROBA_A,PROBA_B))
	{
	if(!warm_up)
	  {
	  	int x = (PROBA_A < PROBA_B ? b++ : a++);
	  }
	    return (PROBA_A < PROBA_B ? B_USE : A_USE);
	}
	else
	{
	if(!warm_up)
	 {
	  	int y = (PROBA_A < PROBA_B ? a++ : b++);//pour la compilation le int
	 }
	    return (PROBA_A < PROBA_B ? A_USE : B_USE);
	}
    }



/*---------------------------------------------------------------*/
/**
 *  fais passerles utilisateurs de waiting_users a connected_users 
 *  tant que possible
*/ 
private void connectWaiters ()
{
	boolean stop = false;
	Client clien = waiting_users.getFirst();
		while(clien != null && !stop) 
		    {
			if(use + clien.getBandwidth () <= BANDE)
			    {
			   
				use += clien.getBandwidth();//on reserve de la bande passante pour le client
				wastingtime = Math.max(wastingtime,clien.getWaitCounter());//on calcule le temps d' attente max
				temps_moyen += clien.getWaitCounter();//on ajoute sont temps d' attente au futur taux moyen d' attente
				connected_users.insertLast(clien);
				waiting_users.deleteFirst();
				clien = waiting_users.getFirst();
			    }
			    else
			    {
			    UI.showDebug("USE :"+use+"BWU client  :"+clien.getBandwidth()+"BANDE"+BANDE); 
			   stop=true;//il n'y a pas deplace pour le premier alors on arete de connecter les waiters
			   }
			   
		    }
}  


/*---------------------------------------------------------------------*/



/*---------------------------------------------------------------*/    
 
/**execute la simulation pendant x tour(s) sans prendre en compte les resultats
@param La dure du warm - up en IT*/
public void warmUp (int x) 
    {
    warm_up = true;
	if (x<0) return;
	for (int i = 0;i<x;i++)	
	       {
		   newUsers ();
		   connectWaiters ();
		   connected_users.decreaseCallDuration ();
		   waiting_users.increaseWaiting ();
		   use -= connected_users.deleteTimeOff ();
	       }
	//UI.showInfo ("connectes durant le warm-up :"+w_connected+"  gain"+gain_total+"  Use:"+use);
	
    }
/** Configure certains parametres de la simulation comme la moyenne d' arrive des clients
par it, le prix du paquet, le nombre d' appels a effectuer*/
public void config () {

	while(moy<=0)
	{
		UI.showInfo("Donnez la moyenne d'arrivee de clients par IT.");
		moy=UI.askInt();
	}

	UI.showInfo("Donnez le nombre d' appels de la simulation.");
	this.nb_appels = UI.askInt();
	appels_restants = nb_appels;
	
	if(par_it)
	{
		UI.showInfo("Donnez le prix d' un paquet.");
		this.price = UI.askInt();
		
	}
	else
	{
		UI.showInfo("Indiquez la fourchette de prix pour laquelle"
			    +"\n\t vous desirez realiser la simulation");
		
		UI.showInfo("\t prix de depart");
		prix_depart = UI.askInt();
		
		UI.showInfo("\t prix maximum");
		prix_max = UI.askInt();	
	}
  }
      
  /** 
	Affecte a un nouveau client sa duree de communication
	@param Le client auquel on va affecter la duree de communication
*/
private void callDuration(Client client)
    {
    
	int duree_voulue = calculeCallDuration((client.getBWU() == A_USE ? TIME_A : TIME_B));
	//si il est de la classe A calculer sa duree d' appel desiree avec 
	//la moyenne relative a sa classe
 
	int duree_accordee = (int) Math.min(duree_voulue,(int)(client.getBudget()/(client.getBWU()*price)));
	//la duree accordee a l' utilisateur est le minimum entre ce qu' il desire
	//et ce qu' il peut se payer
	//System.out.println("BWU :"+client.getBWU()+"|| Budget  "+client.getBudget());
	//System.out.println("duree_accordee :"+(int)((double)client.getBudget()/(double)(client.getBWU()*price)));
	client.setCallDuration (duree_accordee);
	
	//	int insatisfaction = (int)((double)1/(((double)duree_accordee/(double)duree_voulue)*100));


	double greviste=0.;


	if(duree_accordee == 0)
	    greviste = 100.;//maximum d' insatisfaction
	  
	else
	    greviste = (1.-((double)duree_accordee/(double)duree_voulue))*100.;
	
	if(!warm_up)
	{
		//pour eviter de prendre en compte les resultats du warm_up
	    if(greviste > 1)
	    {
		insatisftot += greviste;
		insatisfaits++;
	    }	    
	    else
	    
	    {
		if(greviste <= .5)
		    insatisftot -= greviste;
		    
	    }
	}

	
    }

}
