/* 
 *         CLASS ListeC  V 1.1
 *
 * Classe servant a la creation de liste simplement chainee
 * d'clients.
 *
 *  liste de type FIFO.
 */

class ListeC {
 
 
 // Variables de pointage: Retourne le premier et le dernier maillon.
 private Maillon first, last;
 
public ListeC() {
 this.first=null;
 this.last=null;
}


//------------------------------//

/**  Methode d'insertion en queue , en tete si liste vide  */
public void insertLast(Client toi) {
  // Creation du maillon [ toi | null ]  
   Maillon x = new Maillon(toi);
  //x.content=toi;

  if(first==null) // teste si la liste est vide.
      { 
       first = x;
       first.next=null; // facultatif.
       last=first;
      }
      else {
            x.next=last;
            last=x;
           }

}


/** Retourne le maillon precedent un maillon M */
public Maillon getPrevious(Maillon M) {
    Maillon L=last;

    if(first!=null)
    {
	if(L==M) return null;
	while( L!=null && L.next!=M )
	{
	    L=L.next;
	}
	return L;
    }
    return null;
}
	

/** Methode qui efface le premiere utilisateur de la liste */
public void deleteFirst() {
    // Pointeur volant:
    Maillon L=last;

   // SI_PAS( 1seul element ET vide)
   if(last!=first && first!=null)
   {
	while( L!=null && ((L.next).next) != null)
	{
	    L=L.next;
	}

 	if(L.next==first) first=L; // Cas de liste a 2 elements.
	else first=L.next;         // Cas de liste a PLUS de 2 elements.
	first.next=null;
   }
   else if(last==first)            // Si 1 element (ou vide)
        {
          last=null;
	  first=null;
	}
   
    L=null; // Garbage collection.
}


/** Efface les client sans budget de la liste */
public void deleteBudgetOff() {
   // pointeur volant
    Maillon L=last;

    if(first!=null)
    {
	while( L!=first && L!=null )
	 {
		 if(L.content.getBudget() <= 0)
		 {
		     // Supression de l'element L.
		     Maillon Lprev = getPrevious(L);
		     if(Lprev==null) 
		     {   // L est le dernier element.
			 // Jefface le dernier element.
			 last=L.next;
			 L=last;
		     }
		     else 
		     {
			 Lprev.next=L.next;
			 L=null;
			 L=Lprev; // ou bien L=Lprev.next;
		     }
		 }
		 else L = L.next;
	 }

        if(first.content.getBudget() <= 0) 
	    deleteFirst();
    }
}

// Retire tous les utilisateurs ne pouvant pa payer le prix PRICE.
public int deleteBudgetOff(int price) {
   // pointeur volant
    Maillon L=last;
    int compte=0;

    if(first!=null)
    {
	while( L!=first && L!=null )
	 {
		 if(L.content.getBudget() < price)
		 {
		     compte+=L.content.getBandwidth();//
		     // Supression de l'element L.
		     Maillon Lprev = getPrevious(L);
		     if(Lprev==null) 
		     {   // L est le dernier element.
			 // Jefface le dernier element.
			 last=L.next;
			 L=last;
		     }
		     else 
		     {
			 Lprev.next=L.next;
			 L=null;
			 L=Lprev; // ou bien L=Lprev.next;
		     }
		 }
		 else L = L.next;
	 }

        if(first.content.getBudget() <= 0) {
	    deleteFirst();
	    compte+=first.content.getBandwidth();
	}
    }
    return compte;
}


/** Efface les client de la liste ayant terminee leur com 
    renvoie la capacite de bande qu' utilisait les utilisateurs vires*/
 
public int  deleteTimeOff() {
   // pointeur volant
    Maillon L=last; 
    int compte = 0;//
    if(first!=null)
    {
        while( L!=first && L!=null )
         {
                 if(L.content.getCallDuration() <= 0)
                 {
	             compte+=L.content.getBandwidth();
                     // Supression de l'element L.
                     Maillon Lprev = getPrevious(L);
                     if(Lprev==null) 
                     {   // L est le dernier element.
                         // Jefface le dernier element.
                         last=L.next;
                         L=last;
                     }
                     else
                     {
                         Lprev.next=L.next;
                         L=null;
                         L=Lprev; // ou bien L=Lprev.next;
                     }
                 }
                 else L = L.next; 
         }

        if(first.content.getCallDuration() <= 0) 
	    {    
		compte+=first.content.getBandwidth();//
		deleteFirst();
	    }
    }
    return compte;
}

/** elimine les clients dont le temps d' attente est superieur a
    leur temps de communication desire renvoie le nb de clients elimines
 @return le nombre de clients eliminee
 */
public int deleteWaitOff () {
    Maillon L=last;
    int compte = 0;//
    if(first!=null)
    {
        while( L!=first && L!=null )
         {
                 if(L.content.getCallDuration() == L.content.getWaitCounter())
                 {
                     // Supression de l'element L.
                     Maillon Lprev = getPrevious(L);
                     if(Lprev==null)
                     {   // L est le dernier element.
                         // Jefface le dernier element.
                         compte++;//
                         last=L.next;
                         L=last;
                     }
                     else
                     {
                         compte++;//
                         Lprev.next=L.next;
                         L=null;
                         L=Lprev; // ou bien L=Lprev.next;
                     }
                 }
                 else L = L.next;
         }

        if(first.content.getCallDuration() == L.content.getWaitCounter())
            {
                compte++;//
                deleteFirst();
            }

    }
    return compte;
}

/** elimine les clients dont le temps d' attente est superieur a 
    leur temps de communication desire renvoie le nb de clients elimines
    @param le temps d'attente max tolere par les utilisateurs
    @return le nombre de clients eliminee
 */
public int deleteWaitOff (int waitOff) {
    Maillon L=last;
    int compte = 0;//
    if(first!=null)
    {
        while( L!=first && L!=null )
         {
                 if(L.content.getCallDuration() == waitOff)
                 {
                     // Supression de l'element L.
                     Maillon Lprev = getPrevious(L);
                     if(Lprev==null)
                     {   // L est le dernier element.
                         // Jefface le dernier element.
                         compte++;//
                         last=L.next;
                         L=last;
                     }
                     else
                     {
                         compte++;//
                         Lprev.next=L.next;
                         L=null;
                         L=Lprev; // ou bien L=Lprev.next;
                     }
                 }
                 else L = L.next;
         }

        if(first.content.getCallDuration() == waitOff)
            {
                compte++;//
                deleteFirst();
            }

    }
    return compte;
}



//------------------------------//


/** Diminue le temps de communication de tout les clients de la liste */
public void decreaseCallDuration() {
    Maillon L = last;
    
    if(first!=null)
    {
	while(L!=null)
	{
	    L.content.reduceCallDuration(1);
	    L = L.next;
	}
    }
}

public void decreaseCallDuration(double price) {
    Maillon L = last;
    
    if(first!=null)
    {
	while(L!=null)
	{
	    L.content.reduceCallDuration(1, price);
	    L = L.next;
	}
    }
}

/* Augmente le temps d'attente de tout les clients de la liste 
 * Et retourne le temps d'attente additionnel de tous les clients
 */
public int increaseWaiting() {
    Maillon L = last;
    int w=0;
    
    if(first!=null)
    {
	while(L!=null)
	{
	    L.content.waiting();
	    w += L.content.getWaitCounter();
	    L = L.next;
	}
    }
    return w;
}

/** DEBUG : Affiche un listing de la liste Du dernier au Premier */
public void displayList() {
    Maillon L=last;

    if(first==null) {
	System.out.println("Liste vide... dommage !");
    }
    else {
	    while(L!=null) {
		System.out.println("Client CallDur & Type "
		                    +L.content.getCallDuration()
				    +" "+L.content.getType());
		L=L.next;
	    }
    }
    L=null;
}


//------------- Methodes simples ---------------//

/** @return le nombre de clients contenus dans la liste */
public int numberOfClients() {
    Maillon L=last;
    int x=0;
    while(L!=null) {
	x++;
	L=L.next;
    }
    return x;
}

/** @return le nombre de clients contenus dans la liste */
public int numberOfClientsBand(int cuse) {
    Maillon L=last;
    int x=0;
    while(L!=null) {
	if(L.content.getBandwidth()==cuse) x++;
	L=L.next;
    }
    return x;
}

/**  @return La somme des temps d'attente des utilisateurs de la liste.*/
public int getWaitingSum() {
    Maillon L=last;
    int x=0;
     while(L!=null) {
	 x+=L.content.getWaitCounter();
	 L=L.next;
     }
     return x;
}

/**  @return La somme des temps de communication restant des utilisateurs de la liste. */
public int getCallDurationSum() {
    Maillon L=last; 
    int x=0;
     while(L!=null) {
         x+=L.content.getCallDuration();
         L=L.next;
     }
     return x;
}

/** @return La somme des taux de lassitude */
public double getLassitude() {
    Maillon L=last;
    double x=0;
    while(L!=null) {
	x+=(double)((double)L.content.getWaitCounter()/(double)L.content.getCallDuration());
	L=L.next;
    }
    return x;
}


/** retourne l'UTISATEUR en PREMIER de la liste */
public Client getFirst() {
    if(first!=null)
    return first.content;
    return null;
}

/** retourne l'UTISATEUR en DERNIER de la liste */
public Client getLast() {
    if(first!=null)
    return last.content;
    return null;
}

/** retourne vrai si la liste est vide- Avec test plus complet */
public boolean isEmpty () 
{
// Bien que return(first==null) suffise
    if(this.first == null && this.last==null) 
	{
	    //System.out.println("1 :"+this.first+"    "+this.last);
	    return true;
	}
    else
	{
	    //System.out.println("2 :"+this.first+"    "+this.last);
	    return false;
	}
} 

/** reset, remise a zero fictive de la liste */
public void reset() {
    first=null;
    last=null;
}

//----  End Of CLASS  ----//
}
