/*
 *  class Log V 0.1
 *
 *  Management methods for file streams.
 */

import java.io.*;

class Log {
    
    BufferedWriter in;
    private String name="";
    
public Log () {}

public Log (String name) 
    {
	this.name=name;
	set_buf(name);
    }

//pour initialiser le bufferedwriter
public void set_buf(String name) {
	try
	    {
		in = new BufferedWriter(new FileWriter(name));
	    }catch(IOException e)
		{System.out.println("constr  :"+e.getMessage());}
    }

//ferme le flux d' ecriture
public void fermer() 
    {
	try
	    {
		in.close();
	    }catch(IOException e)
		{System.out.println("fermer :"+e.getMessage());}
    }

//ecris une ligne dans le fichier puis saute une ligne
public void ecrire(String str) 
    {
	try
	    {
		in.write(str);
		in.newLine();
	    }catch(IOException e) 
		{System.out.println("ecrire  :"+e.getMessage());}
    }

//recopie un fichier dans le fichier sur lequel on ecris
public void recopie(String source) {
	
	String str = "";
	try
	    {
		
		BufferedReader br = new BufferedReader( new FileReader(source));
		while((str = br.readLine()) != null)
		    {
			in.write(str);
			in.newLine();
		    }
	    }catch(IOException e) 
		{System.out.println("ecrire  :"+e.getMessage());}
	
    }

//saute une ligne dans le fichier
public void saut_de_ligne(){
	try
	    {
		in.newLine();
	    }catch(IOException e){System.out.println(e.getMessage());}
    }
    
//recopie les fichiers specifies dans le fichier courant
public void regroupe_fichiers(String [] sources)	
    {
	for(int	i=0;i<sources.length;i++)
	    {	
		recopie(sources[i]);
		saut_de_ligne();
				
	    }
	fermer();
    }	

//concatene les fichiers 1 et 2 dans le fichier courant
public void cat (String fichier1, String fichier2) {
	String [] sources = new String [2];
	sources [0] = fichier1;
	sources [1] = fichier2;
	regroupe_fichiers(sources);
    }


// Donne le nom du fichier surlequel l'objet Log travail
public String getFileName() {
    return name;
}

//formate la ligne avant de la passer a ecrire
public static String formater(int x, int y) 
    {
	String str = "";
	str=x+" "+y;
	return str;
    }

public static String formater(double x, int y) 
    {
	String str = "";
	str=x+" "+y;
	return str;
    }

public static String formater(double x,double y) 
    {
	String str = "";
	str=x+" "+y;
	return str;
    }

public static String formater(int x, double y) 
    {
	String str = "";
	str=x+" "+y;
	return str;
    }

// EOC
}
