/*
 *         class PriorityPricing V 1.7
 *   PriorityPricing entre deux classes de clients A et B
 *                   clients de differente priorite
 *                   et de different budget (2 types).
 *
 *   V0.3 integrates WARM UP of the network.
 *   V1.1 integrates clients' non-satisfaction.
 *   V1.4 graphs are drawing according to clients' priorities.
 *           
 */

class PriorityPricing extends XPricing
{
    int prix1=1, prix2=5, prixmax1=250;
    //le prix1 correspond pour une priorite 0
    //le prix2 pour une priorite 1

    //proba pour une classe d' apparaitre
    double a=0.8,
           b=0.2;
    double proba_poor = 0.8,
           proba_rich = 0.2;
    // Budget A | B
    double poor=60.,
           rich=600.;

    //final int BANDE=100; cest 100 pour toute les classe PRICING.

    // Utilisation dela bande passante en % (pour les clients A et les B)
    int a_use=1,
        b_use=5;
    // Temps de connexion moyen par classe de client
    int time_a=36,
        time_b=240;
	
    //  INSATISFACTION et LASSITUDE generales par classe A | B
    double insatisfactionA, nb_insatiA;
    double insatisfactionB, nb_insatiB;
    double lassitudeA;
    double lassitudeB;
    
    int moy=1; // Moyenne de la loi de poisson (voir new_users())
    int appels_restants=0 , nb_total_clients=0;
    int news=0, nb_it=0,
        nb_budgetOffA=0, nb_budgetOffB=0,
        appels_clientsB=0, appels_clientsA=0,
	great_total_clients=0;
    boolean WARMUP=false, // Pour effectuer un warmup -> true
            PAR_IT=true,  // Pour faire une simu par IT sinon (false) par prix de paquets
	    LAS_ON=false,
	    AB_IS_PRIORITY=true;

    ListeC connected_usersA, connected_usersB,
           waiting_usersA, waiting_usersB;

    /** Objet <u>Log</u> qui sert &agrave; l'enregistrement du revenue du fournisseur.*/
    Log revenue;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement de l'utilisation de la bande passante.*/
    Log BWlog;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement du nombre de nouveaux connect&eacute;s (clients A).*/
    Log clientsALog;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement du nombre de nouveaux connect&eacute;s (clients B).*/
    Log clientsBLog;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement du temps d'attente moyen pour les clients de classe A.*/
    Log attenteLogA;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement du temps d'attente moyen pour les clients de classe B.*/
    Log attenteLogB;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement de l'insatisfaction des clients de classe A.*/
    Log insatisfactionLogA;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement de l'insatisfaction des clients de classe B.*/
    Log insatisfactionLogB;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement de lassitude clients de classe A.*/
    Log lassitudeLogA;
     /** Objet <u>Log</u> qui sert &agrave; l'enregistrement de lassitude clients de classe B.*/
    Log lassitudeLogB;

 
/* --- CONSTRUCTOR --- */
public PriorityPricing(UInterface UI) {
    super(UI);

    UI.showInfo("\t\t\t  PRIORITY   PRICING\n");
    // Type de simulation
    UI.showInfo("\n Vous voulez effectuer une simulation :"
	        +"\n\t0 -->  par IT         \t(execution rapide, s'arrete quand plus d'utilisateurs connectes)"
		+"\n\t1 -->  par Prix/Paquet\t(execution longue, suivant la tranche de prix selectionnee)");
    if(UI.askInt()==0) PAR_IT=true;
    else PAR_IT=false;

    // Demande du nombre de clients
    UI.showInfo(" Combien d'appels de clients voulez-vous simuler ? (Pour un/chaque prix fixe)");
    nb_total_clients= UI.askInt();
    appels_restants = nb_total_clients;

    UI.showInfo(" Donnez la moyenne d'arrivee de nouveaux clients par IT  [de 1 a 10 (haute congestion du reseau)]");
    moy= UI.askInt();
    
    if(PAR_IT) {
	// Demande du prix par Packet
	UI.showInfo(" Donnez le prix des clients de classe A (1 paquet par IT)");
	prix1=UI.askInt();
	UI.showInfo(" Donnez le prix des clients de classe B (5 paquets par IT)");
	prix2=UI.askInt();
	
    }
    else {  // PAR_IT=false, il s'agit donc d'une simulation par prix de paquet.
	// Demande la tranche de prix dont la variation est geree par la simulation
	UI.showInfo(" Determinez la tranche de prix pour la simulation ");
	UI.showInfo("\t\t Borne inferieur \t[Prix initial = 1] \\/ ");
	prix1=UI.askInt();
	UI.showInfo("\t\t Borne superieur \t[Prix max final = 250] /\\ ");
	prixmax1=UI.askInt();
    }

    // Demande si les clients las doivent se deconnecter ou pas.
    /* UI.showInfo(" Voulez vous que les clients remplissant la condition suivante (lassitude) :"
	             +"\n\t\t   temps d'attente   >   temps de communication"
		     +"\n\t     se deconnectent par lassitude ?"
		     +"\n\t  0  --> OUI"
		     +"\n\t  1  --> NON"
		     );
	if(UI.askInt()==0) LAS_ON=true;
	else LAS_ON=false;
    */
    
    // Demande si un WARMUP est necessaire.
    UI.showInfo(" Voulez-vous generer un WARM-UP du reseau ?"
                +"\n\t  0 --> OUI"
		+"\n\t  1 --> NON");
    if(UI.askInt()==0) WARMUP=true;
    
    LAS_ON=true;
     UI.showInfo(" Lassitude automatique:"
     +"\n\t\t les clients se deconnectent lorsque Tps D'attente >= Tps de Communication");

     
    // Objets d'enregistrement.  fichier= nom Prix1 E Prix2 - nombre_de_client Clients
    if(PAR_IT) {
	attenteLogA = new Log("PP-attenteLogA---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	attenteLogB = new Log("PP-attenteLogB---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	clientsALog = new Log("PP-clientsALog---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	clientsBLog = new Log("PP-clientsBLog---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	insatisfactionLogA = new Log("PP-insatisfactionLogA---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	insatisfactionLogB = new Log("PP-insatisfactionLogB---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	BWlog = new Log("PP-BandePassante---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	revenue = new Log("PP-revenue---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	lassitudeLogA = new Log("PP-lassitudeLogA---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
	lassitudeLogB = new Log("PP-lassitudeLogB---"+prix1+"E"+prix2+"-"+nb_total_clients+"Clients");
    } else {
	attenteLogA = new Log("PP-attenteLogA---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	attenteLogB = new Log("PP-attenteLogB---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	clientsALog = new Log("PP-clientsALog---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	clientsBLog = new Log("PP-clientsBLog---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	insatisfactionLogA = new Log("PP-insatisfactionLogA---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	insatisfactionLogB = new Log("PP-insatisfactionLogB---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	BWlog = new Log("PP-BandePassante---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	revenue = new Log("PP-revenue---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	lassitudeLogA = new Log("PP-lassitudeLogA---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
	lassitudeLogB = new Log("PP-lassitudeLogB---"+prix1+"TO"+prixmax1+"-"+nb_total_clients+"Clients");
    }

    
    /*
    revenue.ecrire(Log.formater(0,0));
    BWlog.ecrire(Log.formater(0,0));
    clientsBLog.ecrire(Log.formater(0,0));
    clientsALog.ecrire(Log.formater(0,0));
    attenteLog.ecrire(Log.formater(0,0));
    */

    // ListeC d'utilisateurs
    connected_usersA = new ListeC();
    connected_usersB = new ListeC();
    waiting_usersA = new ListeC();
    waiting_usersB = new ListeC();

}

    /*|-----------------------------------------|
      |          LAUNCH SIMULATION              |
      |_________________________________________|*/

public void launchSimulation() {
	UI.showInfo("------ Debut de la simulation ! -------");
	
	if(PAR_IT) {
	    /*
	     * lancement de la simulation par IT
	     * La simulation s'arrete quand le nombre d'appels
	     * demandee a l'utilisateur a ete produit.
	     * Et les log & stats sont ecrite et printed.
	     */
	    launchPAR_IT();
       }
	else { 
	     //----  SIMULATION PAR PRIX PAR PAQUET  ----//
	     /*
	      * lancement de la simuation par Prix par paquets
	      * variant de prix1 a prixmax1
	      */
             launchPAR_PAQUET();
       }// end of else

        // --- ---  FIN DE SIMULATION  --- --- //
        // JE ferme les flux de fichiers pour enregistrement.
         revenue.fermer();
         BWlog.fermer();
         clientsALog.fermer();
         clientsBLog.fermer();
	 attenteLogA.fermer();
	 attenteLogB.fermer();
	 insatisfactionLogA.fermer();
	 insatisfactionLogB.fermer();
	 lassitudeLogA.fermer();
	 lassitudeLogB.fermer();

        // Information de la fin de simulation
	    
	    
    UI.showInfo("---------   Fin de la simulation !    ----------");
    UI.showInfo("\n\t\t @  Drawing graphs... \n\n");
    if(PAR_IT) {
	if(AB_IS_PRIORITY) {
	//UI.showGnuplot(insatisfactionLogB.getFileName(), "Taux d'insatisfaction (clients prioritaires) par IT", "Intervals de temps", "Taux d'insatisfaction");
	//UI.showGnuplot(insatisfactionLogA.getFileName(), "Taux d'insatisfaction (clients non-prioritaires) par IT", "Intervals de temps", "Taux d'insatisfaction");
        UI.showGnuplot(attenteLogB.getFileName(), "Temps d'attente moyen (clients prioritaires /IT)");
        UI.showGnuplot(attenteLogA.getFileName(), "Temps d'attente moyen (clients non-prioritaires /IT)");
	UI.showGnuplot(lassitudeLogA.getFileName(), "Taux de lassitude moyen (non-prioritaires /IT)");
	UI.showGnuplot(lassitudeLogB.getFileName(), "Taux de lassitude moyen (prioritaires /IT)");
	UI.resetGraph();
	UI.saveGraph(revenue.getFileName(), "Revenue du fournisseur par IT");
	UI.saveGraph(BWlog.getFileName(), "Utilisation de la Bande-Passante par IT");
	UI.showAllGraphs();
	UI.showGnuplot(BWlog.getFileName(), "Utilisation de la Bande-Passante par IT");
	
	} else {
        UI.showGnuplot(clientsALog.getFileName(), "Nombre Clients A par IT");
        UI.showGnuplot(clientsBLog.getFileName(), "Nombre Clients B par IT");
        UI.showGnuplot(insatisfactionLogA.getFileName(), "Taux d'insatisfaction (clients A /IT)");
        UI.showGnuplot(insatisfactionLogB.getFileName(), "Taux d'insatisfaction (clients B /IT)");
        UI.showAllGraphs();
        UI.showGnuplot(attenteLogA.getFileName(), "Temps d'attente moyen (clients A /IT)");
        UI.showGnuplot(attenteLogB.getFileName(), "Temps d'attente moyen (clients B /IT)");
        UI.showAllGraphs();
        UI.showGnuplot(revenue.getFileName(), "Revenue du fournisseur par IT");
        UI.showGnuplot(BWlog.getFileName(), "Utilisation de la Bande-Passante par IT");
        UI.showAllGraphs();
	}
    } else {
	// -------------- PAR PRIX PAR PAQUET ------------//
	if(AB_IS_PRIORITY) {
        UI.showGnuplot(insatisfactionLogB.getFileName(), "Taux d'insatisfaction (clients prioritaires) par prix", 
	                                                 "Prix du paquet (classe A)", "Taux d'insatisfaction");
        UI.showGnuplot(insatisfactionLogA.getFileName(), "Taux d'insatisfaction (clients non-prioritaires) par prix", 
	                                                 "Prix du paquet (classe A)", "Taux d'insatisfaction");
        UI.resetGraph();
        UI.saveGraph(attenteLogA.getFileName(), "Temps d'attente moyen (clients prioritaires /prix)");
        UI.saveGraph(attenteLogB.getFileName(), "Temps d'attente moyen (clients non-prioritaires /prix)");
        UI.showAllGraphs();
	UI.showGnuplot(lassitudeLogA.getFileName(), "Taux de lassitude moyen (non-prioritaires /prix)");
	UI.showGnuplot(lassitudeLogB.getFileName(), "Taux de lassitude moyen (prioritaires /prix)");
        UI.showGnuplot(revenue.getFileName(), "Revenue du fournisseur par prix",
	 "prix du paquet (classe A)", "Montant monetaire");
        UI.showGnuplot(BWlog.getFileName(), "Utilisation moyenne de la Bande-Passante par prix",
	 "prix du paquet (classe A)", "pourcentage d'utilisation de la bande passante");
	} else {
        UI.showGnuplot(clientsALog.getFileName(), "Nombre Clients A par prix par paquet");
        UI.showGnuplot(clientsBLog.getFileName(), "Nombre Clients B par prix par paquet");
	UI.resetGraph();
        UI.showGnuplot(BWlog.getFileName(), "Utilisation moyenne de la Bande-Passante (par prix de paquet)");
        UI.showGnuplot(attenteLogA.getFileName(), "Temps d'attente moyen des clients A par prix par paquet");
        UI.showGnuplot(attenteLogB.getFileName(), "Temps d'attente moyen des clients B par prix par paquet");
        UI.showAllGraphs();
        UI.showGnuplot(insatisfactionLogA.getFileName(), "Taux d'insatisfaction moyen des clients A  par prix par paquet");
        UI.showGnuplot(insatisfactionLogB.getFileName(), "Taux d'insatisfaction moyen des clients B  par prix par paquet");
        UI.showAllGraphs();
        UI.showGnuplot(revenue.getFileName(), "Revenue du fournisseur suivant le prix du paquet");
	}
    }

}// End of launchSimulation()



/**
 *  Lancement de la simulation par IT
 * @return void
 */
public void launchPAR_IT() {
    
	// WARMING UP the network 
	if(WARMUP) {
	    warmup(200, false);
	}
	else UI.showInfo("No WARMUP executed.");

        int gain_total=0, total_use=0, gain_it=0,
	    wtimeA=0, tmpA=0,
	    wtimeB=0, tmpB=0,
	    nb_clientsA=0, nb_clientsB=0,
	    it_stopA=0, it_stopB=0, // Fin d'entree de nouveau clients.
	    total_clientsA=0, total_clientsB=0,
	    nb_clientsAlas=0, nb_clientsBlas=0,
	    nb_clientsAlas_it=0, nb_clientsBlas_it=0
	    ;
	boolean saveStopCallA=false, saveStopCallB=false;
	    
	nb_it=0; // Mise a zero du compteur d'IT
	insatisfactionA=0.;
	insatisfactionB=0.;
	lassitudeA=0.;
	lassitudeB=0.;
	nb_budgetOffA=0;
	nb_budgetOffB=0;
	nb_insatiA=0.;
	nb_insatiB=0.;


        while(appels_restants>0  
               ||   !(connected_usersA.isEmpty() && connected_usersB.isEmpty())
               ||   !(waiting_usersA.isEmpty() && waiting_usersB.isEmpty()) )
            {
		nb_insatiA=0.;
		nb_insatiB=0.;
                // Nombre d'appels pour cet IT.
                if(appels_restants>0) new_users(true);
		// else UI.showInfo("Simuation waiting for last users' communications to end.");
		
		// L'insatisfation a ete calculee dans callDuration()<--def_user()<--new_users()
		insatisfactionLogA.ecrire(Log.formater(nb_it, insatisfactionA/nb_insatiA));
		insatisfactionLogB.ecrire(Log.formater(nb_it, insatisfactionB/nb_insatiB));
		insatisfactionA=0.;
		insatisfactionB=0.;

                // s'il y en a et si possible fais passer les waiters dans les connected
		// D'abord les clients de class B , ensuite ceux de class A.
                connect_waiters(waiting_usersB, connected_usersB );
                connect_waiters(waiting_usersA, connected_usersA );

                // Retire un IT a chaque client connecte
                connected_usersA.decreaseCallDuration((double)prix1);
                connected_usersB.decreaseCallDuration((double)prix2);

                // Ajoute un au temps d' attente de chaque client en attente
		// et calcule la moyenne de temps d'attente pour cette IT
                wtimeA = waiting_usersA.increaseWaiting();
		tmpA   = waiting_usersA.numberOfClients();
                wtimeB = waiting_usersB.increaseWaiting();
		tmpB   = waiting_usersB.numberOfClients();
		if(tmpA==0) wtimeA=0;
		else wtimeA = wtimeA / tmpA; // Avoid division by zero.
                if(tmpB==0) wtimeB=0;
		else wtimeB = wtimeB / tmpB; // Avoid division by zero.
                attenteLogA.ecrire(Log.formater(nb_it, wtimeA));
                attenteLogB.ecrire(Log.formater(nb_it, wtimeB));
                wtimeA=0;
		wtimeB=0;

		// Calcul le taux de lassitude moyen des classes A et B
		if(waiting_usersA.numberOfClients()!=0)
		lassitudeA = (double)((waiting_usersA.getLassitude()*100.) / (double)waiting_usersA.numberOfClients());
		else lassitudeA = 0.;

		if(waiting_usersB.numberOfClients()!=0)
		lassitudeB = (double)((waiting_usersB.getLassitude()*100.) / (double)waiting_usersB.numberOfClients());
		else lassitudeB =0.;
		lassitudeLogA.ecrire(Log.formater(nb_it, lassitudeA));
		lassitudeLogB.ecrire(Log.formater(nb_it, lassitudeB));

		if(LAS_ON && AB_IS_PRIORITY) {
		    nb_clientsAlas += waiting_usersA.deleteWaitOff();
		    nb_clientsBlas += waiting_usersB.deleteWaitOff();
		}
		
                // Calcule le gain pour cet IT et ecris dans le fichier revenue...
		if(AB_IS_PRIORITY) {
		    gain_it =  connected_usersA.numberOfClientsBand(a_use)*prix1
		            +  connected_usersA.numberOfClientsBand(b_use)*prix2
		            +  connected_usersB.numberOfClientsBand(a_use)*prix1
		            +  connected_usersB.numberOfClientsBand(b_use)*prix2;
		} else {
		    gain_it =  connected_usersA.numberOfClients()*prix1
			    +  connected_usersB.numberOfClients()*prix2; 
		}
		gain_total += gain_it;
		revenue.ecrire(Log.formater(nb_it, gain_it)); 

                // Retire les connectes ayant termine leur communication
                // et ne prend plus en compte leur Bandwidth Use.
                use-=connected_usersA.deleteTimeOff();
                use-=connected_usersB.deleteTimeOff();

                total_use+=use;
		BWlog.ecrire(Log.formater(nb_it,use));

		total_clientsA += appels_clientsA;
		total_clientsB += appels_clientsB;
		if( (total_clientsB+total_clientsA >= nb_total_clients) && (appels_clientsA==0 && !saveStopCallA)) 
		     { it_stopA=nb_it; saveStopCallA=true;}
		if( (total_clientsB+total_clientsA >= nb_total_clients) && (appels_clientsB==0 && !saveStopCallB))
		     { it_stopB=nb_it; saveStopCallB=true;}
                nb_it++;

		appels_clientsA=0;
		appels_clientsB=0;
         }

	// STATISTIQUES
	UI.showInfo("\n -----------------------------  STATISTIQUES  --------------------------  ");
	if(AB_IS_PRIORITY)
	UI.showInfo("\n\t\t\t Clients A ==> Clients Prioritaires\n\t\t\t Clients B ==> Clients Prioritaires.");
	UI.showInfo("\n\n"
	    +"\t* Nombre d'interval de temps (it) :\t"+nb_it
            +"\n\t* Utilisation moyenne de la bande  :\t"
	    + (int)(((double)total_use)/((double)(nb_it*BANDE))*100)
	    +"\n\t* Productivite d'1% de bande passante :\t"+ ((double)gain_total / (double)total_use)
	    +"\n\t* CONNEXIONS " 
	    +"\n\t\t - Moyenne de la loi de poisson (nbr de clients par IT) :\t"+moy
	    +"\n\t\t - Nombre d'appels traites :\t"+(nb_total_clients-appels_restants)
	    +" sur "+ nb_total_clients +" Appels demandees."
	    +"\n\t\t - Arret des nouvelles connexions de clients A a l'it = "+it_stopA
	    +"\n\t\t - Arret des nouvelles connexions de clients B a l'it = "+it_stopB
            +"\n\t* DECONNEXIONS "
	    +"\n\t\t - Par lassitude clients A : "+(LAS_ON ? ""+nb_clientsAlas : "Option non-activee")
	    +"\n\t\t - Par lassitude clients B : "+(LAS_ON ? ""+nb_clientsBlas : "Option non-activee")
            +"\n\t* NON-CONNEXIONS "
	    +"\n\t\t - Par budget insuffisant clients A : "+nb_budgetOffA
	    +"\n\t\t - Par budget insuffisant clients B : "+nb_budgetOffB
	    +"\n\n");
	
} // End of launchPAR_IT()


/*
 *  lancement de la simulation par prix par paquet
 */
public void launchPAR_PAQUET() {
    
	// WARMING UP the network 
	if(WARMUP) {
	    warmup(200, false);
	}
	else UI.showInfo("No WARMUP executed.");
	
        int gain_total=0, total_use=0, gain_it=0,
	    wtimeA=0, tmpA=0,
	    wtimeB=0, tmpB=0,
	    nb_clientsA_parprix=0, nb_clientsB_parprix=0,
	    it_stopA=0, it_stopB=0, // Fin d'entree de nouveau clients.
	    great_total_clientsA=0, great_total_clientsB=0,
	    p=prix1,
	    nb_clientsAlas=0, nb_clientsBlas=0
	    ;

	nb_it=0;
	great_total_clients = 0;
	// Les causes du warmup environ 20 clients ont attendu (en moyenne)
	tmpA=connected_usersA.numberOfClients();
	tmpB=connected_usersB.numberOfClients();
	insatisfactionA=0.;
	insatisfactionB=0.;
	lassitudeA=0.;
	lassitudeB=0.;
	
	while( prix1 <= prixmax1) {
	 // Fixation des prix :
	    prix2 = prix1*5;
	
	if(WARMUP) {
	    warmup(100, true);
	//  Mais d'abord on retire les clients en attente ki ne peuvent
	//  plus se payer les prix ki ont augmenteer
	waiting_usersA.deleteBudgetOff(prix1);
	waiting_usersB.deleteBudgetOff(prix2);
	connected_usersA.deleteBudgetOff(prix1);
	connected_usersB.deleteBudgetOff(prix2);
	}
	     

        nb_insatiA=0.;
	nb_insatiB=0.;
	insatisfactionA=0.;
	insatisfactionB=0.;
	lassitudeA=0.;
	lassitudeB=0.;

	// ici appels_restants represente le nombre d'IT.
        while(appels_restants!=0  
               ||   !(connected_usersA.isEmpty() && connected_usersB.isEmpty())
               ||   !(waiting_usersA.isEmpty() && waiting_usersB.isEmpty()) )
            {
                // Nombre d'appels de clients A ou B pour cet IT.
	       if(appels_restants > 0) new_users(true);

	       nb_clientsA_parprix += appels_clientsA;
	       nb_clientsB_parprix += appels_clientsB;

                // s'il y en a et si possible fais passer les waiters dans les connected
		// D'abord les clients de class B , ensuite ceux de class A.
                connect_waiters(waiting_usersB, connected_usersB );
                connect_waiters(waiting_usersA, connected_usersA );

                // Retire un IT a chaque client connecte
                connected_usersA.decreaseCallDuration((double)prix1);
                connected_usersB.decreaseCallDuration((double)prix2);

                // Ajoute un au temps d' attente de chaque client en attente
		// et comptabilise le temps totale d'attente ainsi
		// que le nombre culumeer sur toutes les IT de clients en attente par IT
                wtimeA += waiting_usersA.increaseWaiting();
                wtimeB += waiting_usersB.increaseWaiting();
		tmpA += waiting_usersA.numberOfClients();
		tmpB += waiting_usersB.numberOfClients();

		// Calcul le taux de lassitude moyen des classes A et B
		if(waiting_usersA.numberOfClients()!=0)
		lassitudeA += (double)((waiting_usersA.getLassitude()*100.) / (double)waiting_usersA.numberOfClients());
		else lassitudeA+=0.;
		if(waiting_usersB.numberOfClients()!=0)
		lassitudeB += (double)((waiting_usersB.getLassitude()*100.) / (double)waiting_usersB.numberOfClients());
		else lassitudeB+=0.;

		if(LAS_ON && AB_IS_PRIORITY) {
		    nb_clientsAlas += waiting_usersA.deleteWaitOff();
		    nb_clientsBlas += waiting_usersB.deleteWaitOff();
		}
		
                // Calcule le gain pour cet IT et ecris dans le fichier revenue...
		if(AB_IS_PRIORITY) {
		    gain_it =  connected_usersA.numberOfClientsBand(a_use)*prix1
		            +  connected_usersA.numberOfClientsBand(b_use)*prix2
		            +  connected_usersB.numberOfClientsBand(a_use)*prix1
		            +  connected_usersB.numberOfClientsBand(b_use)*prix2;
		} else {
		    gain_it =  connected_usersA.numberOfClients()*prix1
			    +  connected_usersB.numberOfClients()*prix2; 
		}
		gain_total += gain_it;
		gain_it =0; //Facultatif

                // Retire les connectees ayant terminees leur communication
		// car tous les clients en com peuvent se la payer.
                // On ne prend plus en compte leur BandwidthUse.
                use-=connected_usersA.deleteTimeOff();
                use-=connected_usersB.deleteTimeOff();

                total_use+=use;
                nb_it++;
		appels_clientsA=0;
		appels_clientsB=0;
	    }
	// <-------- Fin de la simulation pour un Prix fixee.
	
	// Enregistrement du temps d'attente moyen pour le prix1 fixee
	wtimeA = wtimeA / (tmpA==0 ? 1 : tmpA); // Avoid division by zero.
	wtimeB = wtimeB / (tmpB==0 ? 1 : tmpB); // Avoid division by zero.
	attenteLogA.ecrire(Log.formater(prix1, wtimeA));
	attenteLogB.ecrire(Log.formater(prix1, wtimeB));
	wtimeA=0; tmpA=0;
	wtimeB=0; tmpB=0;

	// Enregistrement de l'insatisfaction moyenne par classe ou priorite
	if(nb_insatiA==0.)
	    insatisfactionLogA.ecrire(Log.formater(prix1,insatisfactionA));
	else
	insatisfactionLogA.ecrire(Log.formater(prix1, insatisfactionA/nb_insatiA) );
	if(nb_insatiB==0.)
	    insatisfactionLogA.ecrire(Log.formater(prix1,insatisfactionB));
	else
	insatisfactionLogB.ecrire(Log.formater(prix1, insatisfactionB/nb_insatiB ));

        // Enregistrement du taux de lassitude moyen par prix.
	lassitudeLogA.ecrire(Log.formater(prix1, lassitudeA / (double)nb_it));
	lassitudeLogB.ecrire(Log.formater(prix1, lassitudeB / (double)nb_it));
	
        // Enregistrement du nombre d'utilisateurs A et B pour prix1	
	clientsALog.ecrire(Log.formater(prix1, nb_clientsA_parprix));
	clientsBLog.ecrire(Log.formater(prix1, nb_clientsB_parprix)); 
	great_total_clientsA += nb_clientsA_parprix;
	great_total_clientsB += nb_clientsB_parprix;
	nb_clientsA_parprix=0;
	nb_clientsB_parprix=0;

	// Enregistrement du revenue fournisseur, gain.
	revenue.ecrire(Log.formater(prix1, gain_total)); 
        gain_total=0; gain_it=0;	

	// Enregistrement de la moyenne (/it) d'utilisation de la Bande passante
	// pour un certain prix de paquet.
	if(total_use==0)
	    // Simulation d'une legere utilisation: < 1 equivaut a 0, car total_use est un entier
	    BWlog.ecrire( Log.formater( prix1, 0.4 )); 
	else
	    BWlog.ecrire( Log.formater( prix1, (double)total_use / (double)nb_it ));
	total_use=0; 
	nb_it=0;
	// use=use, pour garder un warm up 'naturel' du reseau.
	appels_restants=nb_total_clients;

	// Reset les listes d'utilisateurs (clients)
	connected_usersA.reset();
	connected_usersB.reset();
	waiting_usersA.reset();
	waiting_usersB.reset();

	prix1++;
	} // End of while(prix1 <= prixmax1)

	// STATISTIQUES
        UI.showInfo(" STATISTIQUES\n "
	    +"\n\tNombre d'appels traites :\t"+ (great_total_clientsA + great_total_clientsB)
	    +" sur "+ (nb_total_clients*(prixmax1-p)) +" Appels potentiels."
	    +"\n\t");

} // end of launchPAR_PAQUET()


// Fin des methodes de simulation par it et par prix par paquet.
//--------------------------------------------------------------//

/*
 *   Methode de WARM UP du reseau simulant le fait que
 *   la bande passante soit utilisee avant que les clients
 *   que l'on sonde arrivent.
 */
private void warmup(int n, boolean WARMED) {
    if(n<=0) n=200; 
    int tmpn=n;
    // 200 ou n IT pour de Clients virtuels
    if(!WARMED) UI.showInfo("--- Warming up the network...");
    while(n>0) {
	// Virtual Clients who load the network
	new_users(false);

	connect_waiters(waiting_usersB, connected_usersB );
	connect_waiters(waiting_usersA, connected_usersA );
	connected_usersA.decreaseCallDuration();
	connected_usersB.decreaseCallDuration();
	waiting_usersA.increaseWaiting();
	waiting_usersB.increaseWaiting();
	// On ne touche pas au gain pour l'instant car les clients
	// sont virtuels jusqu'a la fin des n IT de warm-up

	// Par contre la bande passante est reellement utilisee.
	use-=connected_usersA.deleteTimeOff();
	use-=connected_usersB.deleteTimeOff();
			
	n--;
    }
    appels_clientsA=0;
    appels_clientsB=0;

    if(!WARMED)
UI.showInfo("    ----  Network has been warmed up.  ----\n"
	    +"\t"+ (connected_usersA.numberOfClients() + connected_usersB.numberOfClients())
	    +" clients left out of "+tmpn+" virtual simulated clients.");
}



/* 
 *  fonction qui initialise les clients et cherche a les 
 *  caser sur la bande ou dans la liste waiting _users
 */ 
private void new_users (boolean WARMED)  {
    // WARMED sert a savoir si le reseau a subit un WARM-UP(true) ou pas (false).
    //majore le nb d'arrivants par le nb d'appels restants
    news = newUsers (moy, appels_restants); 

    // Comptabilize le nombre d'appels qui ont donnees suite ou pas.
    great_total_clients += news;
    
    for(int i=0;i<news;i++)  {
	    // Definition et initialisation d'un nouveau client.
	    def_user();
         
            //un nouveau client a appelle, on comptabilise son appel.
            if(WARMED) appels_restants--;
        UI.showDebug("appels_restants   :"+appels_restants);  
    }

    // Enregistrement du nombre de clients A et B arrivants.	
    if (WARMED && PAR_IT) {
	clientsALog.ecrire(Log.formater(nb_it, appels_clientsA)); 
	clientsBLog.ecrire(Log.formater(nb_it, appels_clientsB)); 
    }

}
 

/*
 * Definit le profil d'un utilisateur. 
 *
 */
private void def_user()  {

    // INITIALISATIION d'un nouveau client
	Client client = new Client ();
        client.setPriority( priority() );
        // L'utilisation de bande passante est definie suivant
	// la priorite choisie (aleatoirement) par l'utilisateur.
	if(client.getPriority()==0) {
	    client.setBudget( budget() );
	    client.setBWU( band() );
	} else {
	    client.setBudget( budget() );
	    client.setBWU( band() );
	}

	//initialise la duree d' appel et calcule l'insatisfaction (Premier pas)
	callDuration (client);
        
       // Si budget suffisant. Et temps de communication > 1 IT
       // on rentre l'utilisateur directement dans la liste d'attente.
       if (client.getCallDuration() >= 1 )
       {
	   if( (int)(client.getBudget()) >= prix1 ) 
	       if(AB_IS_PRIORITY) {
		   
		   if(client.getPriority()==0) {
		        waiting_usersA.insertLast(client);
			appels_clientsA++;
		   } else {
		       waiting_usersB.insertLast(client);
		       appels_clientsB++;
		   }
		   
		} else {
		    
		   if (client.getBWU()==a_use) {
		    UI.showDebug("  <- A -> Waiting Connexion of budget "
				 +client.getBudget()+" price is "
				 +prix1+"E /"+prix2);
		    waiting_usersA.insertLast(client);
		    appels_clientsA++;
		   }
		   else 
		   if( (int)(client.getBudget()) >= prix2 ) {     
		    UI.showDebug("  <- B -> Waiting Connexion of budget "
				+client.getBudget()+" price is "
				+prix2+"E /"+prix1);
		    waiting_usersB.insertLast(client);
		    appels_clientsB++;
		   }
		}
		
       } else {  // Client refusee = non-connexion
           if(AB_IS_PRIORITY)
           if(client.getPriority()==0) nb_budgetOffA++;
	   else nb_budgetOffB++;
       }
}


/*
 *  fais passerles utilisateurs de waiting_users a connected_users 
 *  tant que possible, suivant les contrainte du Flat Pricing.
 * METHOD OF PARENT CLASS
 * protected void connect_waiters ( ListeC source, ListeC dest )
 */


//------------------------------------------------------------------//
//retourne le budget d' un utilisateur
private double budget()  {
	//on tire le budget
	
	if(Math.random() < Math.max(proba_poor,proba_rich))
	    {
		return (proba_rich > proba_poor ? rich : poor);
		//si on a tire un chiffre inferieur a la proba max 
		//si la proba max est celle des pauvre on retourne le budget des pauvres
		//sinon on retourne le budget des riches
	    } 
	else
	    {
		//on a tire un chiffre superieur a la proba max 
		//donc on est dans le cas le moins frequent
		//si le cas special est celui des riches on retourne le budget des riches
		//sinon on retourne le budget des pauvres
		return (proba_rich > proba_poor ? poor : rich);
	    }
}


//renvoie la priorite 
//0 pour normal (classe A, pauvre ou aisee)
//1 pour prioritaire (classe B, riche ou tres aisee)
private int priority()  {

	if(Math.random()<Math.max(proba_poor, proba_rich))
	    return (proba_poor < proba_rich ? 1 : 0 );
	else
	    return (proba_poor < proba_rich ? 0 : 1 );
}

//determine le taux de bande utilise
//or taux <=> classe
// a_use   ==> Classe A
// b_use   ==> Classe B
private int band()  {
	if(Math.random() < Math.max(proba_poor, proba_rich))
	    return (a < b ? b_use : a_use);
	else
	    return (a < b ? a_use : b_use);
}


private void callDuration(Client client)  {
        double greviste=0.;
	int prix = (client.getBWU() == a_use ? prix1 : prix2);
	//si un client est de priorite 1 lui faire payer le prix1
	//sinon lui faire payer le prix2

	int duree_voulue = calculeCallDuration((client.getBWU() == a_use ? time_a : time_b));
	
	//si il est de la classe A calculer sa duree d' appel desiree avec 
	//la moyenne relative a sa classe
 
	//int duree_accordee = (int)Math.min(duree_voulue,client.getBudget()/(client.getBWU()*prix));
	int duree_accordee=0;
	int duree_calculee = (int)((int)client.getBudget()/(prix));
	if(duree_calculee > duree_voulue)
	    duree_accordee=duree_voulue;
	else if(duree_calculee >= 1)
	    duree_accordee=duree_calculee;
	
	//la duree accordee a l' utilisateur est le minimum entre ce qu' il desire
	//et ce qu' il peut se payer

	client.setCallDuration(duree_accordee);

	// INSATISFACTION de la demande-client = client (abus de langage)
	// si duree_voulue/duree_accordee > 0.5 ----> client insatisfait
	// si duree_voulue/duree_accordee <= 0.5 ----> ravi (reussite du service)
        // LE tout divizee par 100.	
	if(duree_accordee==0)
	    greviste = 100.;
	    // duree_voulue/1 = maximum d'insatisfaction
	else
	    greviste = (double)( 1.-(double)duree_accordee/(double)duree_voulue) * 100.;
	
	if( greviste > 1.)   // Client clairement insatisfait
	    if(AB_IS_PRIORITY)
		if(client.getPriority() == 0) {  insatisfactionA += greviste ; nb_insatiA +=1.;}
		else 				{insatisfactionB += greviste ; nb_insatiB +=1.;}
	    else
		if(prix==prix1){  insatisfactionA += greviste ; nb_insatiA +=1.;} 
		else 		{insatisfactionB += greviste ; nb_insatiB +=1.;}
	else 
	 // if(greviste < 1.015 && greviste > 1.0) 
	 // Client satisfait normalement qui ne s'attache pas au service.
	 if( greviste <= 0.5 )
	    if(AB_IS_PRIORITY)
		if(client.getPriority() == 0)   insatisfactionA -= greviste ;
		else				insatisfactionB -= greviste ;
	    else
		if(prix==prix1) insatisfactionA -= greviste ;
		else 		insatisfactionB -= greviste ;
} // End of callDuration(Client) 


//--- EOC
}
