/**
 *              TODPricing V 0.2
 * la classe TODPricing qui implemente les methodes necessaires
 * a la simulation de type TOD
 *
 */

class TODPricing extends XPricing {

    
    private static final int RICH = 600, POOR = 60;     //budget d' un riche, d' un pauvre
    private static final double PROBA_A = 0.8;          //PROBA_B=0.2 ||proba qu'user soit de la classe A
    private static final double PROBA_BUDGET = 0.8;     //proba qu' un user soit pauvre
    private static final int A_USE = 1, B_USE = 5;      // % de bp utilisee pr la classe A
    
    private int nb_it_par_heure;
    private  int A_TIME , B_TIME ; // duree moy de com  pr la classe A

    private final int BANDE=100;
    private static final double PROBA_E = 0.2;          //Proba de l'elasticite


    private int PRICE;                 //prix par paquet
    private int hours = 0;
    private int use, nb_it=1;
    private int appels_restants, connected=0, wasting_time;
    private int nb_appels = 0, moy =2; //MOY=moyenne de la loi de poisson
    private int wait_normal_users =0,wait_elastic_users = 0;
    
    private int p_A = 1,p_B =5;   
    private boolean period_creuse = true;

    Log gain_par_heure, utilisation_par_heure, attente_par_heure;
    Log attente_elastic, number_client;
    
    ListeC connected_users, waiting_users, elastic_users;


// CONSTRUCTOR
public TODPricing (UInterface UI) {
	super(UI);

	UI.showInfo("Donnez le nombre max d'it par heure (simulation sur 24h, conseil: 4 IT / Heure)");
	nb_it_par_heure = UI.askInt();
	/*UI.showDebug(nb_appels+" clients prevus.");
	appels_restants = nb_appels;*/

	A_TIME = 36/nb_it_par_heure;
	B_TIME = 240/nb_it_par_heure;

	// Creation d'objet pour gere different flux de fichier.
	// Enregistrement de l'evolution du gain et de l'utilisation de la BP
	gain_par_heure = new Log("TOD_gain_par_heure");
	utilisation_par_heure = new Log("TOD_utilisation_bp");
	attente_par_heure = new Log("TOD_attente_client_normal_par_heure");
	number_client = new Log("TOD_nombre_client");
	attente_elastic =  new Log("TOD_attente_client_elastic_par_heure");

	// Creation de deux listes de client
	// les connectes, et les clients en attente.
	connected_users = new ListeC();
	waiting_users = new ListeC();
	elastic_users = new ListeC();

}
/* 22h  12h et 14h  18h -> periode creuse
   12h  14h et 18h  22h -> c'est le prix fort les gars */

/*----------- LAUNCH SIMULATION METHOD ---------*/
public void launchSimulation()
    {
	//warm_up(4);
	int gain_total=0, total_use=0;
	int use_bp = 0;
	nb_appels = 0;
	while(hours != 24)
	    {
			//1 heure correspond a 10 IT
		if(nb_it%4 == 0)
		    {
			use_bp = use - use_bp;
			//System.out.println("wait_norm "+wait_normal_users+" wait_elas "+wait_elastic_users);
			attente_par_heure.ecrire(Log.formater(hours,wait_normal_users));
			attente_elastic.ecrire(Log.formater(hours,wait_elastic_users));
			gain_par_heure.ecrire(Log.formater(hours,payer()));	
			print_use(use);
			number_client.ecrire(Log.formater(hours,nb_appels));
			hours++;
			nb_appels = 0;
			wait_normal_users = 0;
			wait_elastic_users = 0;
		    }

		period_creuse = DefPeriod(hours);
		
		PRICE = DefPrice(hours);
		// Nombre d'appels pour cet IT.
		
		new_users(period_creuse);

		
		// s'il y en a et si possible fais passer les waiters dans les connected
		connect_waiters();
		
		//Insere les elastic_users si periode creuse
		if(period_creuse == true)
		    WantInsertElastic_Users();

		TakeOffWaitUsers();
		// Retire un IT a chaque client connecte
		connected_users.decreaseCallDuration();
		
		// Ajoute un au temps d' attente de chaque waiter
		waiting_users.increaseWaiting();
		elastic_users.increaseWaiting();

		// Calcule le gain pour cet IT et ecris dans le fichier gain_par_it
		gain_total += payer();
		
		// Vire les connectes ayant termine leur communication
		// et ne prend plus en compte leur Bandwidth Use.
		//System.out.println("use "+use);
		use-=connected_users.deleteTimeOff();
		
		//System.out.println("use apres supp client "+use);

		wait_normal_users += waiting_users.numberOfClients();
		wait_elastic_users += elastic_users.numberOfClients()   ;

		

		total_use+=use;
		nb_it++;
	    }

	//DEBUG// connected_users.displayList();

	// JE ferme les flux de fichiers pour enregistrement.
	gain_par_heure.fermer();
	utilisation_par_heure.fermer();
	attente_par_heure.fermer();
	attente_elastic.fermer();
	number_client.fermer();

	System.out.println("nb_appals "+nb_appels);
	System.out.println("gain_total "+gain_total);

	try
	    {
		Process p = Runtime.getRuntime().exec("/dmoreira/simu/");
	    }
	catch(Exception e){}
	// Information de la fin de simulation
	UI.showInfo(" it   :"+nb_it+"//connectes : "+connected+"// appels :"+(nb_appels-appels_restants));
	UI.showInfo((double)total_use+"   "+(double)(nb_it*BANDE));
	UI.showInfo("Utilisation moyenne de la bande  :"+(int)(((double)total_use)/((double)(nb_it*BANDE))*100));

	UI.showAlert("Drawing graphs...");
	UI.showGnuplot(gain_par_heure.getFileName(), "Gain economique");
	UI.showGnuplot(utilisation_par_heure.getFileName(), "Utilisation de la BandePassante");
	UI.showGnuplot(attente_par_heure.getFileName(), "Tps attente des clients norm");
	UI.showGnuplot(attente_elastic.getFileName(), "Tps attente des c elas"); 
	UI.showGnuplot(number_client.getFileName(),"TOD_Nombre_client");
}

/*---------------------------------------------------------------*/
public boolean DefPeriod(int hours)
{
	//Definit le prix par paquet suivant periode creuse
	if(hours<12 || (hours>14 && hours<18) || hours > 22)
	{
		return true;
	}
	else
	{
		return false;
	}
}

public int DefPrice(int hours)
{
	int prix = 0;
	//Definit le prix par paquet suivant periode creuse
	if(hours<12 || (hours>14 && hours<18) || hours > 22)
	{
		prix = p_A;
	}
	else
	{
		prix = p_B;
	}
	return prix;
}

/*---------------------------------------------------------------*/

    /*
     *	fonction qui initialise les clients et cherche a les
     *  caser sur la bande ou dans la liste waiting _users
     */
private void new_users (boolean period_creuse)
    {
	int news =0;
	//majore le nb d'arrivants par le nb d'appels restants
	if(period_creuse == true)
		nb_appels+=(news = Poisson.newUsers (moy));
	else
		nb_appels+=(news = Poisson.newUsers (moy*5));

	UI.showDebug(news+" nouveaux clients un cet IT.");
	for(int i=0;i<news;i++)
	{

	    // On definit le profil du nouvel utilisateur
	    // Cree un client si il peut se payer au mooins un it
	    def_user();
	    // et le place dans la liste d'attente.

	    //un nouveau client a appelle, on comptabilise son appel.
	    //appels_restants--;
	UI.showDebug("appels_restants   :"+appels_restants);
	}

    }

/*---------------------------------------------------------------*/
//definit le profil du client qui vient de se connecter
private void def_user ()
    {
	int budget=0, time=0,time2=0,band=0;
	boolean elasticite = false;

	//Definit si il peut retarder son appel ou pas
	if(Math.random() < PROBA_E)
		elasticite = true;
	else
		elasticite = false;

	//on tire son budget
	if(Math.random() > PROBA_BUDGET)
	    budget = RICH;
	else
	    budget = POOR;

	//on tire sa classe
	if(Math.random() > PROBA_A)
	    {
			//ici utiliser la loi geometrique
			time =  calculeCallDuration(A_TIME);
			// et calculer ce que pourra reellement envoyer l' utilisateur
			band = A_USE;
	    }
	else
	    {
			time = calculeCallDuration(B_TIME);
			band = B_USE;
	    }

	//ce qu' il peut reellement payer
	time2 = Math.min(time,CanPay(time, budget, elasticite, band));

	if(time2 > 0)
	    {
		
		UI.showDebug("connecte");
		connected++;
		if(elasticite == true)
		    elastic_users.insertLast(new Client(0, time, budget, band, elasticite));
		else
		    waiting_users.insertLast(new Client(0, time, budget, band, elasticite));
		//si il y a du monde en attente il se met a la queue
		//si il n' y en a pas il sera traite en premier par connect_waiters
	    }
}

//-------------------------------------------------------//

/*
 *  fais passer les utilisateurs de waiting_users a connected_users
 *  tant que possible, suivant les contrainte du TOD Pricing.
 *
 */
private void connect_waiters ()
{
    boolean stop = false;
    Client clien = waiting_users.getFirst();
    if(clien!=null && !stop)
	{
	    if(use + clien.getBandwidth()<=BANDE)
		{
		    use+=clien.getBandwidth();
		    connected_users.insertLast(clien);
		    waiting_users.deleteFirst();
		}
	    else
		stop = true;
	}
    
		//connected_users.displayList();
}



//---------------------------------------------------------------------//
/* renvoie le prix paye par les utilisateur pour un IT*/
public int payer ()
{
	//le prix de l' IT est le meme a tout moment pour tout utilisateur
	int gain  =  use*PRICE;

	UI.showDebug("paye : "+gain);
	//gain_par_it.ecrire(Log.formater(nb_it,gain));
	return gain;
}


// Enregistre l'utilisation de la bande passante a chaque IT.
public void print_use(int use_bp)
{
	utilisation_par_heure.ecrire(Log.formater(hours,use_bp));
}

//---------------------------------------------------------------------//
/* Regarde si le client peut payer sa duree de com*/
public int CanPay(int duree_com, int budget, boolean elasticite , int band)
{
    int pay = 0;
    int som = 0,it =0;
    if(elasticite == true)
	{
	    if(budget >= duree_com*p_A*band)
		pay = duree_com;
	    else
		pay = real_time(budget,p_A,band);
	}
    else
	{
	    it = hours;
	    // Definit le prix total pour la duree de com
	    for(int i = 1;i<=duree_com;i++)
		{
		    if(i%4 == 0)it++;
		    som+=DefPrice(it)*band;
		}
	    if(budget >=som )pay = duree_com;
	    else
		{
		    it = hours;
		    int i = 1;
		    som = 0;
		    for( i=1 ;i<duree_com;i++)
			{
			    if(i%4 == 0)it++;
			    som+=DefPrice(it)*band;
			    if( som > budget )
				{
				    som-= DefPrice(it)*band;
				    break;
				}
			}
		    if(som>0)pay = i;
		} 
	}
   
    return pay;
}

/*Insere l'utilisateur sur la BP*/
public void WantInsertElastic_Users()
{
    boolean stop = false;
    Client clien = elastic_users.getFirst();
    if(clien != null && !stop)
	{
	    if(use+clien.getBandwidth() <= BANDE)
		{
		    use += clien.getBandwidth();
		    connected_users.insertLast(clien);
		    elastic_users.deleteFirst();
		}
	    else stop = true;
	}
}

/*real-time*/
public int real_time(int budget, int price, int bandwidthuse)
{
    int time = budget/(price*bandwidthuse);
    if(time>0)
	return time;
    else
	return 0;
}

/*warm_up*/
public void warm_up(int time)
{
    int compteur = 0;
    while(compteur != time)
	{
	    //1 heure correspond a 10 IT
	    if(nb_it%4 == 0)
		compteur++;
	    
	    period_creuse = DefPeriod(hours);
	    
	    PRICE = DefPrice(hours);
	    // Nombre d'appels pour cet IT.
	    
	    new_users(period_creuse);
	    
	    //Insere les elastic_users si periode creuse
	    if(period_creuse == true)
		WantInsertElastic_Users();
	    
	    // s'il y en a et si possible fais passer les waiters dans les connected
	    connect_waiters();
	    
	    // Retire un IT a chaque client connecte
	    connected_users.decreaseCallDuration();
	    
	    // Ajoute un au temps d' attente de chaque waiter
	    waiting_users.increaseWaiting();
	    
	    // Vire les connectes ayant termine leur communication
	    // et ne prend plus en compte leur Bandwidth Use.
	    use-=connected_users.deleteTimeOff();	 
	    nb_it++;
	    
	}
}

//Retire les clients qui attente trop longtemps
void TakeOffWaitUsers()
    {
	Client clien = waiting_users.getFirst();
	Client c = elastic_users.getFirst();
	
	if(clien!=null)
	    if(clien.getWaitCounter() >= clien.getCallDuration())
		{
		    waiting_users.deleteFirst();
		    if(waiting_users.getFirst()!=null)clien = waiting_users.getFirst();
		    //else break;
		}
	if(c!=null)
	    if(c.getWaitCounter() >= 2*c.getCallDuration())
		{
		elastic_users.deleteFirst();
		if(elastic_users.getFirst()!=null)c = elastic_users.getFirst();
		//else break;
	    }
    }
}
