/**
  @version 0.7 
 *      UInterface
  <br>Interface definissant les methodes qu'une interface
  console ou graphique (ou autre) devra implementer
  pour etre utilisee dans la simulation.
 
 */

interface UInterface {


//--------- Methodes de demande de variables a l'utilisateur ---//
public boolean askQuit();       // Demande si l'utilisateur veut tout arreter.
public int askInt();            // Simplement.
public int askPricingType();
/*  0 -> FlatPricing
 *  1 -> PriorityPricing
 *  2 -> TimeOfDayPricing ou TODPricing
 *  3 -> Quitter le programme
 *  
 */


 
//--------- Methodes d'affichage d'informations ---//
public void showInfo(String s);
public void showAlert(String s);
public void showDebug(String s);



//--------- Methodes servant a la simulation ---//

/* Trace le graphe defini par le fichier 'file'
 *  de type GNUPLOT avec 'title' le titre du graphe.
 * Et enregistre l'emplacement 
 */
public void showGraph(String file, String title); 

/* Enregistre l'emplacement des fichiers coordonnees
 * dans l'optique de les afficher tous ensemble avec showAllGraphs
 */
public void saveGraph(String file, String title);

 /* Trace le graphe defini par le fichier 'file'
  *  de type GNUPLOT en lancant le program gnuplot
  * lui-meme qui mettra le titre 'title' sur le graphe.
  * Indique aussi ce qui se trouve en abscisse (xlabel)
  * et en ordonee (ylabel).
  */
public void showGnuplot(String file, String title, String xlabel, String ylabel);
public void showGnuplot(String file, String title);

public void showAllGraphs();

/* Ecrase la memoire des graphes. remise a zero.
 */
public void resetGraph();

/*----- END OF INTERFACE UInterface -----*/  
}
