/*
 *   class XPricing V 0.5
 *
 * (Anciennement class Simu)
 * class Mere de tout type de pricing
 *
 */

class XPricing implements Launcher {

    UInterface UI;
    protected final int BANDE=100;
    int use=0;

public XPricing (UInterface UI) {
	this.UI=UI;
}


public void launchSimulation() { 
    // Methode devant etre implementee par chaque type de pricing.
}


/*---------------------------------------------------------------*/
  
 

    /**
    C
    @return la duree de communication d' un utilisateur en fonction de leur moyenne
     * utilise la loi geometrique pour affecter une duree de 
     * communication aleatoire
     */
protected static int duration_call (int lambda) {
	int x = 0;
	double u = Math.random ();
	double somme = Geometrie.proba (lambda, x);
	while (u > somme) 
	    {
		x++;
		somme +=Geometrie.proba (lambda, x);
	    }
	if(Math.random()>0.5) 
	    x= -x;
	
	return lambda+x;
}

    /*
     * renvoie le nb d'IT(borne inf) que peut payer en integralite 
     * le client et donc le temps qu' il passera en communication
     */
protected int real_time(int budget, int price, int bandwidthuse) {
	UI.showDebug("class XPricing : "+budget+" /( "+price+" * "+bandwidthuse);
	int time = budget/(price*bandwidthuse);
	if(time>0)
	    return time;
	else
	    return 0;
}



/*
 *  Passerelle utilisateurs de waiting_users a connected_users 
 *  tant que possible :
 *  Il faut implementer une methode connect_waiters()
 *  qui suivant des parametres propres au type de Pricing
 *  accepte ou de connecter des clients de la liste d'attente.
 *  Puisque cela peut dependre des parametres propres au type de Pricing,
 *  on ne peux pas la mettre de maniere Generique ici dans la class XPricing.
 */

protected void connect_waiters ( ListeC source, ListeC dest )
{
        Client client = source.getFirst();
        if(client!=null)
        while( use + client.getBandwidth()<=BANDE) {
            use+=client.getBandwidth();
            dest.insertLast(client);
            source.deleteFirst();

            client = source.getFirst();
            if(client==null) break;
        }
}


 /** calcule le nb de users qui se connectent pour un IT
      ils arrivent selon une loi de Poisson
     @param la moyenne utilisee pour la loi de Poisson 
     @param  appels restants sert a ne pas depasser le nb d' appels desires
     
     */ 
    public  int newUsers (int lambda, int appels_restants)
    {
	int x = 0;
	double u = Math.random ();
	float somme = Poisson.proba (lambda, x);
	while (u > somme) 
	    {
		x++;
		somme +=Poisson.proba (lambda, x);
	    }

	return Math.min(x,appels_restants);
    }


/** Genere un nombre d' utilisateurs 
@return un nombre d' utilisateurs pour un IT
@param la moyenne d' arrivee par IT des utilisateurs
*/
  public  int newUsers (int lambda)
    {
	int x = 0;
	double u = Math.random ();
	float somme = Poisson.proba (lambda, x);
	while (u > somme) 
	    {
		x++;
		somme +=Poisson.proba (lambda, x);
	    }

	return x;
    }
    
    /** 
    Calcule la duree de communication desiree par un client
    en fonction de son temps moyen de communication correspondant a sa classe
    @param lambda la moyenne de duree d' appel de la classe du client
    @return la duree de communication desiree par le client
    */
    
    public int calculeCallDuration(int moy)
    {
	int x=0;//la duree d' appel
	double u=Math.random();
	double somme=Geometrie.proba(moy,x);
	while(u>somme)
		{	
		x++;
		somme+=Geometrie.proba(moy,x);
		}
	return (x == 0 ? 1 : x);   	
    }
/* // Version simpliste pour une seule reconnexion.
public void connect_waiters(ListeC source, ListeC dest) 
{ Client clien = source.getFirst();
  if(clien!=null){dest.insertLast(clien);source.deleteFirst();}}
*/


//--- EOC
}
