#include <stdio.h>
#include <stdlib.h>   	  /* pour rand() ET RAND_MAX, atoi(), atof(), exit() */
#include <unistd.h>   	  /* pour execlp() */
#include <sys/types.h>    /* pour times */
#include <sys/times.h>    /* pour times */  
#include <ctype.h>        /* pour isdigit() */
#include <string.h>       /* pour strcmp(), strlen()  */
#include <limits.h>       /* pour INT_MAX   */

#define MESSAGE "Erreur, usage : \"client P S N G nom_fichier\", avec P,S,N,G crits en nombres entiers strictements positifs.\n"

/* Dclarations prototypes de fonctions */

void germe(void);       
void traite_erreurs_frappe(char *T[]);

/* Traitement principal */

int main(int argc, char *argv[])
{
   FILE *dt,*set;
   int i,j,p,s,N,G;
   char c;
   float P,S;

   if ((argc != 6)&&((argc != 7)|| (strcmp(argv[6],"-q")!=0))) 
   {
   fprintf(stderr,MESSAGE);
   exit(1);
   }

P=atof(argv[1]); S=atof(argv[2]); N=atoi(argv[3]); G=atoi(argv[4]); 

if ( N<=G ) printf("Hum, la granularit G devrait tre strictement infrieure au nombre de requtes N !\n");
   
traite_erreurs_frappe(argv);  
/* Rem : cette fct utilise une transmission par adresse et ici en l'occurence modifie la position  des pointeurs argv[1],...,argv[4], d'o l'importance ici de recopier ces valeurs AVANT traite_erreurs_frappe() dans les variables P,S,N,G.*/ 
	

if ((strcmp(argv[5],"set.glt")==0)||(strcmp(argv[5],"client")==0))      {
   fprintf(stderr,"Choisir un autre nom de fichier svp...\n");
   exit(5);
   }
   
if ((set=fopen("set.glt","w"))==NULL) 
    {
    fputs("Impossible d'ouvrir en criture le fichier set.glt!\n",stderr);
    exit(6);
    }
else          
    {    
    fprintf(set,"set terminal x11\nset pointsize 0.5\nset title 'Une squence de %d requtes (granularit %d).'\nset xlabel '%d Pistes'\nset ylabel '%d Secteurs'\nset nokey\nplot '%s' with linespoints pt 2\npause -1 \"- Taper entre (ici dans le shell) pour quitter gnuplot -\"\n", N, G, (int)P, (int)S , argv[5]);
    fflush(set);
    fclose(set);
    }     

germe();  
   
p=(int)((P*rand())/(RAND_MAX+1.0));	   /* Nb alatoire entre 0 et P-1 */
s=(int)((S*rand())/(RAND_MAX+1.0));   	   /* Nb alatoire entre 0 et S-1 */ 

if ((dt=fopen(argv[5],"w"))==NULL)
    {
    fprintf(stdout,"Impossible d'ouvrir en criture le fichier %s!\n",argv[5]);

    exit(7);
    }
else
    {
    fprintf(dt,"%s\n", "#Fichier_client");   /* Pour que simulation distingue les requtes des 3 clients */       j=0;
    for(i=0;i<N;i++)
	{
	fprintf(dt,"%d %d\n",p,s++);
	j++;
	if (s==(int)S)
	   { if (p!=((int)P-1)) {p++;s=0;}
	     else {p=0;s=0;}
	   }
	if (j==G) 
	   { 
	   p=(int)((P*rand())/(RAND_MAX+1.0)); 
	   s=(int)((S*rand())/(RAND_MAX+1.0)); 
	   j=0;
	   fprintf(dt,"\n");
	   }
	}
    fflush(dt);
    fclose(dt); 
    if ((argc==7)&&(strcmp(argv[6],"-q")==0)) { exit(0) ; }   /* Mode "quiet" utilis dans simulation */
    else execlp("gnuplot","gnuplot","-geometry","1024x768","-background","cyan,1","set.glt",NULL);
    }
}   /* Fin main() */

void germe(void)
{  
/* Initialisation du gnrateur d'alas */     
   struct tms buffer;
   unsigned long int g;
   unsigned int g_cs;	
	
g=times(&buffer);
g_cs=g-((unsigned long int)(g/100))*100;   /* germe pour srand() : en centimes de seconde */	
srand(g_cs); 
}  

void traite_erreurs_frappe(char *T[])
{
/* Traitement d'erreurs, type "faute de frappe" */

   short i;
   char c;

   for (i=1;i<=4;i++)   
      {
      if ( (long long int)(atof(T[i])) >= INT_MAX )
	      /* "Erreurs" de type arguments >= INT_MAX */
	 {
	 fprintf(stderr,"Erreur : les valeurs donnes doivent tre < %i.\n",INT_MAX);
	 exit(2);
         }
      
      if (atoi(T[i])==0)  /* Prend en compte les erreurs de type T[i]="ab"||"a1"||"000" */ 
	     {
	     fprintf(stderr,MESSAGE); 
	     exit(3);
	     }
      c=*T[i];
      while (c!='\0')
	     { 
	     if (isdigit(c)==0)   /* Prend en compte les erreurs de type T[i]="1a"||"-1" */
		    {
		    fprintf(stderr,MESSAGE); 	
 		    exit(4);
		    }
	      T[i]++;
	      c=*T[i];
	      }
       }
}

