#include <stdio.h>
#include <stdlib.h>   /* pour atoi(), atof(), abs(), qsort(), exit() */
#include <ctype.h>    /* pour isdigit() */
#include <string.h>   /* pour strcmp(), strlen()  */
#include <unistd.h>   /* pour getopt(), unlink()  */
#include <limits.h>   /* pour INT_MAX  */ 

#define MESSAGE1 "Erreur, usage : \"serveur [ -S || -C ] nb_pistes nb_secteurs nom_fichier\"\n"

#define MESSAGE2 "Erreur : le nombre de pistes P et le nombre de secteurs S doivent tre crits en entiers strictement positifs.\n" 

#define MESSAGE3 "Impossible d'ouvrir le fichier %s!\n"

#define MESSAGE4 "Suppression fichier %s impossible!\n"

int o;         /* Variable "extern" pour options */
char *P,*S;    /* Nombre pistes, nombre secteurs, donns en argument du programme */
typedef struct couple
{
  int piste;
  int secteur;
} couple;

void traite_erreurs_frappe(void) ;
void calcul_dates(char *F) ;
int compScan(couple *A, couple *B) ;
int compCscan(couple *A, couple *B) ;  /* Fonctions de comparaison */
char *num_requetes(char *F) ;       /* Pour conserver le numro initial des requtes */
char *tri(char *F) ;                /* Le tri (fonction de l'une des 2 options -S ou -C choisies) */


int main(int argc, char *argv[])
{  
   char *F;
   extern char *P,*S;
   extern int o;
   extern int optind;
		
if ( (o = getopt(argc, argv, "SC")) != EOF )
     {
     if (argc != 5) { fprintf(stderr,MESSAGE1) ; exit(1); }
     if (optind==2) { P=argv[2] ; S=argv[3] ; F=argv[4] ; }
     if (optind==3) { P=argv[1] ; S=argv[3] ; F=argv[4] ; }
     if (optind==4) { P=argv[1] ; S=argv[2] ; F=argv[4] ; }
     if (optind==5) { P=argv[1] ; S=argv[2] ; F=argv[3] ; }
     traite_erreurs_frappe();
     F=num_requetes(F);
     if ( o == 'S' ) printf("\n- Mode SCAN - \nLes requtes initiales (groupes par 100) sont traites par ordre croissant lexicographique sur les couples (piste, secteur) :\n\n");
     else if ( o == 'C' ) printf("\n- Mode C-SCAN : \nLes requtes initiales (groupes par 100) sont traites aprs tre ordonnes via l'ordre sur les couples (piste, secteur) donn par :\n \t\t (p',s') > (p,s) <=> S(p'-p)+(s-s') > 0 \n\n");
     else if ( o == '?' ) { fprintf(stderr,MESSAGE1) ; exit(1); }
     }
else  
    {
    if (argc != 4) { fprintf(stderr,MESSAGE1) ; exit(1); }
    P=argv[1]; S=argv[2]; F=argv[3];
    traite_erreurs_frappe();
    F=num_requetes(F);
    printf("\n- Mode par dfaut -\nLes requtes sont traites successivement dans l'ordre o elles ont t cres :\n\n");
    }

if ( (o == 'S')||(o == 'C') )  F=tri(F); 

calcul_dates(F);
 
if (unlink(F)==-1) fprintf(stderr,MESSAGE4,F);      /* Fichier temporaire */
                                 
fputs("\n",stdout);
}

void traite_erreurs_frappe(void)
{
   char *T[2]; 
   char c;
   int i;

   T[0]=P; T[1]=S;  /* Les manipulations suivantes changent la position des pointeurs *T[i], donc ne pas travailler directement avec P ou S */

for (i=0;i<=1;i++)
    {
    if ( (long long int)(atof(T[i])) >= INT_MAX )
         /* "Erreurs" de type argument > INT_MAX */
	{
	fprintf(stderr,"Erreur : les valeurs donnes doivent tre < %i.\n",INT_MAX);
	exit(5);
        }
    if (atoi(T[i])==0)  /* Prend en compte les erreurs de type P,S="ab"||"a1"||"000" */
	{
	fprintf(stderr,MESSAGE2);
	exit(2);
	}
    c=*T[i];
    while (c!='\0')
	  {
	  if (isdigit(c)==0)   /* Prend en compte les erreurs de type P,S="1a"||"-1" */
	     {
	     fprintf(stderr,MESSAGE2);
             exit(2);
	     }
	  T[i]++;
	  c=*T[i];                        
	  }	
     }          
}

char *num_requetes(char *F) 
{   
   FILE *dt,*ndt;
   char *NF;  
   char str[16];         
   unsigned int p,s;    
   unsigned int i=1;
   short g;
  
if ((dt=fopen(F,"r"))==NULL) { fprintf(stdout,MESSAGE3,F) ; exit(3) ; }

NF=(char *)malloc(strlen(F)+3);   /*strlen ne compte pas le '\0' final, et sprintf en met un  la fin */
sprintf(NF,"%s__",F);       /* Pas "__" avant %s car simulation planterait avec un __/tmp/fichier impossible  ouvrir */ 
/* Note : dans NF le '\0' de F est cras par "__", mais sprintf rajoute ensuite un '\0' en queue de NF*/

if ((ndt=fopen(NF,"w"))==NULL) { fprintf(stdout,MESSAGE3,NF) ; exit(3) ; }

/* Solution de "facilit" choisie ici : passer par un fichier temporaire, plutt que de faire du fseek() sur le fichier (texte...) de requtes initial */

while( (g=fscanf(dt,"%u %u\n", &p, &s)) != EOF )
       {
        if (g==2) fprintf(ndt,"%u %u %u\n", p, s, i++);
	else 
	     {
	        fscanf(dt,"%s",str);
		if (strcmp(str,"#Fichier_client")==0)
		  {
		  fprintf(ndt,"%c %c %c\n",'a', 'a', 'a');
	          /* Pour distinguer les 3 clients dans simulation */
		  i=1;   
		  /* Rinitialisation du compteur de requtes pour chaque client (pour simulation) */
		  }
	        else 
		   {
		    fprintf(stderr,"Erreur : ce fichier %s n'a pas le format d'un fichier de requtes!\n",F); 
		    if (unlink(NF)==-1) fprintf(stderr,MESSAGE4,NF); 
		    exit(5);
		   }
	       }
        fflush(NULL);   /* Faut pas mlanger les critures dans le tampon... */
	} 
fclose(dt);
fclose(ndt);
return NF;
}

void calcul_dates(char *F)
{
   FILE *dt;
   int g;
   short k=1;
   unsigned int i,j,p,s,piste_prcdte,secteur_prcdt,secteur_temp;
   unsigned long int date;
   float duree_int1,duree_int2;

if ((dt=fopen(F,"r"))==NULL) { fprintf(stdout,MESSAGE3,F) ; exit(3) ; }

piste_prcdte=0;
secteur_prcdt=0;
date=0;
j=0;

while( (g=fscanf(dt,"%u %u %u", &p, &s, &i)) != EOF )
       {
       if (g==3) 
	  {
	    /* On calcule d'abord le temps de dplacement pour se placer sur la bonne piste */
	    duree_int1=2+((float)(5*abs(p-piste_prcdte)))/(atof(P));
	    
	    /* La tte de lecture se trouve alors sur un certain secteur (S/5 secteurs parcourus par ms, on arrondit ici au numro de secteur le plus proche...) */ 
            secteur_temp= ((unsigned int)((atof(S)/(float)(5))*duree_int1 +0.5)+secteur_prcdt)%(atoi(S));
	    
	    /* On calcule alors le temps ncessaire pour que la tte se trouve au dessus du bon secteur */
	    if (secteur_temp>s)
	         duree_int2=((float)(5*(atoi(S)-secteur_temp+s)))/(atof(S));
	    else duree_int2=((float)(5*(s-secteur_temp)))/(atof(S)); 
	    
	    /* On obtient la date de traitement (arrondie  l'entier le plus proche : en ms) */
	    date=date+(unsigned long int)(duree_int1+duree_int2+0.5);
       
	    switch (o)      /* Variable extern ! */
	           {
		   case EOF : printf("Requte n%u :   \t piste %u\t secteur %u   \tdate traitement : %lu ms\n", i, p, s, date);
	                      break;
		   case 'S': 
		   case 'C': j++;
	                     if (j%100==0) {
			                    printf("Requte n%u :   \t piste %u\t secteur %u   \tdate traitement : %lu ms\n", i, p, s, date);
			                    printf("\n\n");  /* Pour visualiser les groupes en modes Scan et C-Scan */
		                           }
		             else printf("Requte n%u :   \t piste %u\t secteur %u   \tdate traitement : %lu ms\n", i, p, s, date);
		             break;
		    }
	    piste_prcdte=p;
	    secteur_prcdt=s;
	  }
       else
	   {
	    fputs("\n",stdout);
	    fprintf(stdout, "CLIENT n%d :\n", k++);
	    fputs("\n",stdout);
	    fscanf(dt,"%*c %*c %*c");  /* Avance le pointeur dans le fichier */
	    j=0;
	   }
       }
fclose(dt);
}          

char *tri(char *F)
{  
   FILE *dt,*tdt; 
   char *TF;
   unsigned int T[100][3];
   unsigned short i,j;
   unsigned int p,s,n;
   int g;

if ( (dt=fopen(F,"r"))==NULL ) { fprintf(stdout,MESSAGE3,F) ; exit(3) ; }

TF=(char *)malloc(strlen(F)+4);
sprintf(TF,"%stri",F);          

i=0;
while( (g=fscanf(dt,"%u %u %u\n", &p, &s, &n)) != EOF )
   {
   if (g==3)
      {
       T[i][0]=p ; T[i][1]=s ; T[i][2]=n ; i++;
       if (i==100) 
	     {
	      switch (o)
		 {
		  case 'S' : qsort(T,100,3*sizeof(int),(int (*)())compScan);   /* On trie lexicographiquement les requtes (groupes par 100)*/ 
		             break;
		  case 'C' : qsort(T,100,3*sizeof(int),(int (*)())compCscan);  /* On trie les requtes selon une formule voisine de celle de l'nonc (cf. rapport)*/
		             break;
     /* Note : on conserve dans ces deux tris le numro n d'apparition initial des requtes */
		  }
	      if ( (tdt=fopen(TF,"a"))==NULL )  { fprintf(stdout,MESSAGE3,TF) ; exit(3) ; }                       /* On ajoute des donnes au fichier TF (ou cr si n'existait pas) */
	          
	      for(j=0;j<100;j++)
		  fprintf(tdt,"%u %u %u\n", T[j][0], T[j][1], T[j][2]);
	      fclose(tdt);
	      i=0;
	      }
      }
   else               /* Pour programme simulation : reprer plusieurs clients */ 
       	{
	fscanf(dt,"%*c %*c %*c");
	if ( (tdt=fopen(TF,"a"))==NULL )  { fprintf(stdout,MESSAGE3,TF) ; exit(3) ; }
	if (i!=0)              
	   {          
	   switch (o)   
	       {
	        case 'S' : qsort(T,i,3*sizeof(int),(int (*)())compScan);
	                  break;
	        case 'C' : qsort(T,i,3*sizeof(int),(int (*)())compCscan);
	                  break;
	       }
	   for(j=0;j<i;j++)
	     fprintf(tdt,"%u %u %u\n", T[j][0], T[j][1], T[j][2]);
	   i=0;
	   }
	fprintf(tdt,"%c %c %c\n", 'a','a','a');
	fclose(tdt);
	}
   }      /* Fin while */

fflush(NULL);   /* Ne pas mlanger dans le tampon...  */

switch (o)   /* Lorsque l'on sort entre 0 et 100 du while ci-dessus */
      {
      case 'S' : qsort(T,i,3*sizeof(int),(int (*)())compScan);
	         break;
      case 'C' : qsort(T,i,3*sizeof(int),(int (*)())compCscan);
	         break;
      }
if ( (tdt=fopen(TF,"a"))==NULL )  { fprintf(stdout,MESSAGE3,TF) ; exit(3) ; } 
for(j=0;j<i;j++)
   fprintf(tdt,"%u %u %u\n", T[j][0], T[j][1], T[j][2]);
fclose(tdt);

if (remove(F)!=0) fprintf(stderr,MESSAGE4,F);        /* unlink ne suffit pas sur mon linux (!?) */

return TF; 
}

int compScan(couple *A, couple *B)  /* Comparaison lexicographique pour mode Scan */
{
if ( ( A->piste > B->piste ) || ( (A->piste == B->piste)&&(A->secteur > B->secteur) ) ) return 1;
else if  ( (A->piste == B->piste)&&(A->secteur == B->secteur) ) return 0;
else return -1;
}

int compCscan(couple *A, couple *B)  /* Comparaison pour le mode C-Scan : lexico "semi-invers" */
{
if ( ( A->piste > B->piste ) || ( (A->piste == B->piste)&&(A->secteur < B->secteur) ) ) return 1;
else if  ( (A->piste == B->piste)&&(A->secteur == B->secteur) ) return 0;
else return -1;
}









