#include <stdio.h>  
#include <sys/types.h>     /* Pour mkfifo(), wait() */
#include <sys/stat.h>      /* Pour mkfifo() */
#include <sys/wait.h>      /* Pour wait */
#include <unistd.h>        /* Pour fork(), execl(), getopt() */
#include <ctype.h>         /* pour isdigit() */
#include <string.h>        /* pour strcmp(), strlen()  */
#include <limits.h>        /* pour INT_MAX  */

#define MESSAGE "Erreur, usage : \"simulation P S N G nom_tube [-S || -C]\", avec P,S,N,G crits en nombres entiers strictements positifs (\"-S\" ou \"-C\" tant optionnels).\n"


void traite_erreurs_frappe(void) ;

char *P,*S,*N,*G,*F;

int main(int argc, char *argv[])
{  
   FILE *t;
   char *tmpF; 
   int i, o, pid,status;
   extern int optind;


if ( (o = getopt(argc, argv, "SC")) != EOF )
     {
     if (argc != 7) { fprintf(stderr,MESSAGE) ; exit(1); }
     if (optind==2) { P=argv[2] ; S=argv[3] ; N=argv[4] ; N=argv[5] ; F=argv[6] ; }
     if (optind==3) { P=argv[1] ; S=argv[3] ; N=argv[4] ; G=argv[5] ; F=argv[6] ; }
     if (optind==4) { P=argv[1] ; S=argv[2] ; N=argv[4] ; G=argv[5] ; F=argv[6] ; }
     if (optind==5) { P=argv[1] ; S=argv[2] ; N=argv[3] ; G=argv[5] ; F=argv[6] ; }
     if (optind==6) { P=argv[1] ; S=argv[2] ; N=argv[3] ; G=argv[4] ; F=argv[6] ; }
     if (optind==7) { P=argv[1] ; S=argv[2] ; N=argv[3] ; G=argv[4] ; F=argv[5] ; }
     
     if ( o == '?' ) { fprintf(stderr,MESSAGE) ; exit(1); }
     }
else  
    {
    if (argc != 6) { fprintf(stderr,MESSAGE) ; exit(1); }
    P=argv[1]; S=argv[2]; N=argv[3]; G=argv[4]; F=argv[5];
    }
   
traite_erreurs_frappe();

if ( atoi(N)<=atoi(G) ) printf("Hum, la granularit G devrait tre strictement infrieure au nombre de requtes N !\n");

tmpF=(char *)malloc(strlen(F)+6);
sprintf(tmpF,"/tmp/%s",F);

if ( mkfifo(tmpF,0644)!= 0) {fprintf(stderr, "-Impossible de crer le tube nomm-\n");exit(2);}

pid=fork();

if (pid==0)  /*  FILS */
   { 
     switch (o)
            {
	    case EOF : execl("serveur","serveur", P, S, tmpF, NULL);
	               perror("-Erreur exec serveur-\n");
		       break;
	    case 'S' : execl("serveur","serveur","-S", P, S, tmpF,NULL);
	               perror("-Erreur exec serveur-\n");
	               break;
	    case 'C' : execl("serveur","serveur","-C", P, S, tmpF,NULL);
	               perror("-Erreur exec serveur-\n");
		       break;
     /* Le serveur est bloqu en attente sur le tube nomm argv[5] */
	    }
   }
 else             /* PERE */
   {
/* Il faut ouvrir un crivain qui n'crit rien mais attend que les 3 clients aient fini */
   if ( (t=fopen(tmpF,"w"))==NULL ) fprintf(stderr, "-Impossible d'ouvrir le tube nomm-\n");   	   
   for(i=1;i<=3;i++)
        {
         pid=fork();
	      if (pid==0)
	      		{
			 execl("client","client", P, S, N, G, tmpF,"-q",NULL);  /* client en mode "quiet" : sans gnuplot */
	      		 perror("-Erreur exec client-\n");
			}
	      else wait(&status);
	}
   fclose(t);
   if ( unlink(tmpF)==-1 ) fprintf(stderr,"-Impossible de supprimer le tube nomm-\n");  
   wait(&status);
   exit(0);  
   }
}
 
void traite_erreurs_frappe(void)
{
   char *T[4]; 
   char c;
   int i;

   T[0]=P; T[1]=S; T[2]=N; T[3]=G; /* Les manipulations suivantes changent la position des pointeurs *T[i], donc ne pas travailler directement avec P, S, N, ou G */

for (i=0;i<=3;i++)
    {
    if ( (long long int)(atof(T[i])) >= INT_MAX )
    /* "Erreurs" de type argument > INT_MAX */
	{
	fprintf(stderr,"Erreur : les valeurs donnes doivent tre < %i.\n",INT_MAX);
	exit(2);
        }
    if (atoi(T[i])==0)  /* Prend en compte les erreurs de type P,S="ab"||"a1"||"000" */
	{
	fprintf(stderr,MESSAGE);
	exit(2);
	}
    c=*T[i];
    while (c!='\0')
	  {
	  if (isdigit(c)==0)   /* Prend en compte les erreurs de type P,S="1a"||"-1" */
	     {
	     fprintf(stderr,MESSAGE);
             exit(2);
	     }
	  T[i]++;
	  c=*T[i];                        
	  }	
     }          
}


